/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableDirectoryListingTest {
    private TableDirectoryListing listing;
    private TableStore<Metadata.NoMeta> tablestore;
    private File testDirectory;
    private File tempFile;

    @NotNull
    private static File testDirectory() {
        return DirectoryUtils.tempDir(TableDirectoryListingTest.class.getSimpleName());
    }

    @Before
    public void setUp() throws Exception {
        this.testDirectory = TableDirectoryListingTest.testDirectory();
        this.testDirectory.mkdirs();
        File tableFile = new File(this.testDirectory, "dir-list.cq4t");
        this.tablestore = SingleTableBuilder.binary((File)tableFile, (Metadata)Metadata.NoMeta.INSTANCE).build();
        this.listing = new TableDirectoryListing(this.tablestore, this.testDirectory.toPath(), f -> Integer.parseInt(f.getName().split("\\.")[0]), false);
        this.listing.init();
        this.tempFile = File.createTempFile("foo", "bar");
        this.tempFile.deleteOnExit();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldBlowUpIfClosed() {
        this.tablestore.close();
        this.listing.getMaxCreatedCycle();
    }

    @Test
    public void shouldTrackMaxValue() {
        this.listing.refresh();
        this.listing.onFileCreated(this.tempFile, 7);
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)7));
        Assert.assertThat((Object)this.listing.getMinCreatedCycle(), (Matcher)CoreMatchers.is((Object)7));
        this.listing.onFileCreated(this.tempFile, 8);
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)8));
        Assert.assertThat((Object)this.listing.getMinCreatedCycle(), (Matcher)CoreMatchers.is((Object)7));
    }

    @Test
    public void shouldInitialiseFromFilesystem() throws Exception {
        new File(this.testDirectory, "1.cq4").createNewFile();
        new File(this.testDirectory, "2.cq4").createNewFile();
        new File(this.testDirectory, "3.cq4").createNewFile();
        this.listing.refresh();
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)this.listing.getMinCreatedCycle(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void lockShouldTimeOut() {
        this.listing.onFileCreated(this.tempFile, 8);
        this.listing.onFileCreated(this.tempFile, 9);
        Assert.assertThat((Object)this.listing.getMaxCreatedCycle(), (Matcher)CoreMatchers.is((Object)9));
    }
}

