/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherStateTest {
    @Test
    public void pretouch() {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 65536, record, () -> false);
        ps.pretouch(null);
        ps.pretouch(null);
        Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 4096 as the underlying MappedBytes changed.\ntouchPage 1 til 17 count 17\ndebug pretouch for only 0 of 17 min: 0 MB.\ndebug none: Advanced 4 KB, avg 4 KB between pretouch() and 4 KB while mapping of 0 KB \n", (Object)record.toString());
    }

    @Test
    public void pretouchLeap() {
        long[] pos = new long[]{0x100000L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 4096L;
            return pos[0];
        }, 16384, record, () -> true);
        ps.pretouch(null);
        for (int i = 0; i < 8; ++i) {
            ps.pretouch(null);
            pos[0] = pos[0] + 57344L;
        }
        ps.pretouch(null);
        Assert.assertEquals((Object)"debug none - Reset pretoucher to pos 1052672 as the underlying MappedBytes changed.\ntouchPage 257 til 261 count 5\ndebug none: Advanced 4 KB, avg 4 KB between pretouch() and 4 KB while mapping of 20 KB \ntouchPage 262 til 292 count 31\ndebug none: Advanced 64 KB, avg 19 KB between pretouch() and 4 KB while mapping of 124 KB \ntouchPage 293 til 320 count 28\ndebug none: Advanced 64 KB, avg 30 KB between pretouch() and 4 KB while mapping of 112 KB \ntouchPage 321 til 344 count 24\ndebug none: Advanced 64 KB, avg 38 KB between pretouch() and 4 KB while mapping of 96 KB \ntouchPage 345 til 367 count 23\ndebug none: Advanced 64 KB, avg 45 KB between pretouch() and 4 KB while mapping of 92 KB \ntouchPage 368 til 387 count 20\ndebug none: Advanced 64 KB, avg 49 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 388 til 407 count 20\ndebug none: Advanced 64 KB, avg 53 KB between pretouch() and 4 KB while mapping of 80 KB \ntouchPage 408 til 425 count 18\ndebug none: Advanced 64 KB, avg 55 KB between pretouch() and 4 KB while mapping of 72 KB \ntouchPage 426 til 443 count 18\ndebug none: Advanced 64 KB, avg 57 KB between pretouch() and 4 KB while mapping of 72 KB \n", (Object)record.toString());
    }

    @Test
    public void pretouchLongBreak() {
        long[] pos = new long[]{0L};
        StringBuilder record = new StringBuilder();
        DummyPretoucherState ps = new DummyPretoucherState(() -> {
            pos[0] = pos[0] + 1024L;
            return pos[0];
        }, 16384, record, () -> true);
        for (int i = 0; i <= 20; ++i) {
            record.append("pos: ").append(pos[0]).append(", i:").append(i).append("\n");
            ps.pretouch(null);
        }
        Assert.assertEquals((Object)"pos: 0, i:0\ndebug none - Reset pretoucher to pos 1024 as the underlying MappedBytes changed.\npos: 1024, i:1\ntouchPage 0 til 4 count 5\ndebug none: Advanced 1 KB, avg 3 KB between pretouch() and 1 KB while mapping of 20 KB \npos: 3072, i:2\npos: 4096, i:3\ntouchPage 5 til 5 count 1\ndebug none: Advanced 3 KB, avg 2 KB between pretouch() and 1 KB while mapping of 4 KB \npos: 6144, i:4\npos: 7168, i:5\npos: 8192, i:6\ntouchPage 6 til 6 count 1\ndebug none: Advanced 4 KB, avg 1 KB between pretouch() and 1 KB while mapping of 4 KB \npos: 10240, i:7\npos: 11264, i:8\npos: 12288, i:9\ntouchPage 7 til 7 count 1\ndebug none: Advanced 4 KB, avg 1 KB between pretouch() and 1 KB while mapping of 4 KB \npos: 14336, i:10\npos: 15360, i:11\npos: 16384, i:12\ntouchPage 8 til 8 count 1\ndebug none: Advanced 4 KB, avg 1 KB between pretouch() and 1 KB while mapping of 4 KB \npos: 18432, i:13\npos: 19456, i:14\npos: 20480, i:15\ntouchPage 9 til 9 count 1\ndebug none: Advanced 4 KB, avg 1 KB between pretouch() and 1 KB while mapping of 4 KB \npos: 22528, i:16\npos: 23552, i:17\npos: 24576, i:18\ntouchPage 10 til 10 count 1\ndebug none: Advanced 4 KB, avg 1 KB between pretouch() and 1 KB while mapping of 4 KB \npos: 26624, i:19\npos: 27648, i:20\n", (Object)record.toString());
    }

    class DummyPretoucherState
    extends PretoucherState {
        private final BooleanSupplier touched;
        StringBuilder record;
        boolean first;
        private long last;

        DummyPretoucherState(LongSupplier posSupplier, int headRoom, StringBuilder record, BooleanSupplier touched) {
            super(posSupplier, headRoom);
            this.first = true;
            this.record = record;
            this.touched = touched;
        }

        protected void debug(String message) {
            this.record.append("debug ").append(message).append("\n");
        }

        protected boolean touchPage(MappedBytes bytes, long offset) {
            if (this.first) {
                this.record.append("touchPage ").append(offset / 4096L);
                this.first = false;
            }
            this.last = offset;
            return this.touched.getAsBoolean();
        }

        protected void onTouched(int count) {
            this.record.append(" til ").append(this.last / 4096L).append(" count ").append(count).append("\n");
            this.first = true;
        }
    }
}

