/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexTest
extends ChronicleQueueTestBase {
    @NotNull
    private final WireType wireType;
    private ThreadDump threadDump;

    public IndexTest(@NotNull WireType wireType) {
        this.wireType = wireType;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{WireType.BINARY}});
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.threadDump.ignore("disk-space-checker");
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    @Test
    public void test() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().wireType(this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int i = 0;
            while (i < 5) {
                int n = i++;
                appender.writeDocument(w -> w.write((WireKey)ChronicleQueueTestBase.TestKey.test).int32(n));
                int cycle = queue.lastCycle();
                long index0 = queue.rollCycle().toIndex(cycle, (long)n);
                long indexA = appender.lastIndexAppended();
                this.accessHexEquals(index0, indexA);
            }
        }
    }

    @Test
    public void shouldShortCircuitIndexLookupWhenNewIndexIsCloseToPreviousIndex() throws Exception {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().wireType(this.wireType).build();){
            ExcerptAppender appender = queue.acquireAppender();
            int messageCount = 75;
            long[] indices = new long[75];
            for (int i = 0; i < 75; ++i) {
                try (DocumentContext ctx = appender.writingDocument();){
                    ctx.wire().write((CharSequence)"event").int32(i);
                    indices[i] = ctx.index();
                    continue;
                }
            }
            SingleChronicleQueueExcerpts.StoreTailer tailer = (SingleChronicleQueueExcerpts.StoreTailer)queue.createTailer();
            tailer.moveToIndex(indices[0]);
            Assert.assertThat((Object)tailer.index(), (Matcher)CoreMatchers.is((Object)indices[0]));
            Assert.assertThat((Object)tailer.getIndexMoveCount(), (Matcher)CoreMatchers.is((Object)1));
            tailer.moveToIndex(indices[0]);
            Assert.assertThat((Object)tailer.index(), (Matcher)CoreMatchers.is((Object)indices[0]));
            Assert.assertThat((Object)tailer.getIndexMoveCount(), (Matcher)CoreMatchers.is((Object)1));
            tailer.moveToIndex(indices[2]);
            Assert.assertThat((Object)tailer.index(), (Matcher)CoreMatchers.is((Object)indices[2]));
            Assert.assertThat((Object)tailer.getIndexMoveCount(), (Matcher)CoreMatchers.is((Object)1));
            tailer.moveToIndex(indices[72]);
            Assert.assertThat((Object)tailer.index(), (Matcher)CoreMatchers.is((Object)indices[72]));
            Assert.assertThat((Object)tailer.getIndexMoveCount(), (Matcher)CoreMatchers.is((Object)2));
            tailer.moveToIndex(indices[69]);
            Assert.assertThat((Object)tailer.index(), (Matcher)CoreMatchers.is((Object)indices[69]));
            Assert.assertThat((Object)tailer.getIndexMoveCount(), (Matcher)CoreMatchers.is((Object)3));
        }
    }

    public void accessHexEquals(long index0, long indexA) {
        Assert.assertEquals((String)(Long.toHexString(index0) + " != " + Long.toHexString(indexA)), (long)index0, (long)indexA);
    }
}

