/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleAppenderCycleTest {
    private static final long LATCH_TIMEOUT_MS = 5000L;

    @Test
    public void testAppenderCycle() throws IOException {
        String id = "testAppenderCycle";
        VanillaBytes msg = Bytes.allocateDirect((long)64L);
        int n = 20;
        for (int i = 0; i < n; ++i) {
            this.runTest(id + '-' + i, (Bytes)msg);
        }
        msg.release();
    }

    private void runTest(String id, Bytes msg) throws IOException {
        Path path = Files.createTempDirectory(id, new FileAttribute[0]);
        CountDownLatch steady = new CountDownLatch(2);
        CountDownLatch go = new CountDownLatch(1);
        CountDownLatch done = new CountDownLatch(1);
        int n = 468;
        AtomicReference<Throwable> thr1 = this.useAppender(path, appender -> {
            int i;
            appender.cycle();
            for (i = 0; i < n; ++i) {
                appender.writeBytes(msg);
            }
            steady.countDown();
            this.await(go, "go");
            for (i = 0; i < n; ++i) {
                appender.writeBytes(msg);
            }
        }, done);
        AtomicReference<Throwable> thr2 = this.useAppender(path, appender -> {
            steady.countDown();
            this.await(go, "go");
            int m = 2 * n;
            for (int i = 0; i < m; ++i) {
                appender.cycle();
            }
        }, done);
        this.await(steady, "steady");
        go.countDown();
        this.await(done, "done");
        Assert.assertNull((Object)thr1.get());
        Assert.assertNull((Object)thr2.get());
    }

    private void await(CountDownLatch latch, String name) {
        try {
            latch.await(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Problem acquiring the \"" + name + "\" latch", e);
        }
    }

    private AtomicReference<Throwable> useAppender(Path path, Consumer<ExcerptAppender> tester, CountDownLatch done) {
        AtomicReference<Throwable> refThr = new AtomicReference<Throwable>();
        Thread thread = new Thread(() -> {
            try {
                SingleChronicleQueueBuilder builder = this.createBuilder(path);
                try (SingleChronicleQueue queue = builder.build();){
                    ExcerptAppender appender = queue.acquireAppender();
                    tester.accept(appender);
                }
            }
            catch (Throwable e) {
                refThr.set(e);
            }
            finally {
                done.countDown();
            }
        });
        thread.setDaemon(true);
        thread.start();
        return refThr;
    }

    private SingleChronicleQueueBuilder createBuilder(Path path) {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.builder((Path)path, (WireType)WireType.FIELDLESS_BINARY);
        builder.rollCycle((RollCycle)RollCycles.DAILY);
        return builder;
    }
}

