/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.QueueFileShrinkManager;
import net.openhft.chronicle.queue.impl.single.RollCycleEncodeSequence;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
implements WireStore {
    @NotNull
    final SCQIndexing indexing;
    @NotNull
    private final LongValue writePosition;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final ReferenceCounter refCount;
    @NotNull
    private transient Sequence sequence;
    private volatile Thread lastAccessedThread;

    @UsedViaReflection
    private SingleChronicleQueueStore(@NotNull WireIn wire) {
        assert (wire.startUse());
        try {
            this.writePosition = this.loadWritePosition(wire);
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.refCount = ReferenceCounter.onReleased(this::onCleanup);
            this.indexing = (SCQIndexing)Objects.requireNonNull(wire.read(MetaDataField.indexing).typedMarshallable());
            this.indexing.writePosition = this.writePosition;
            this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, this.rollIndexCount(), this.rollIndexSpacing());
        }
        finally {
            assert (wire.endUse());
        }
    }

    public SingleChronicleQueueStore(@NotNull RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, int indexCount, int indexSpacing) {
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        indexCount = Maths.nextPower2(indexCount, 8);
        indexSpacing = Maths.nextPower2(indexSpacing, 1);
        this.indexing = new SCQIndexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newTwoLongReference().get();
        this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, rollCycle.defaultIndexCount(), rollCycle.defaultIndexSpacing());
    }

    @NotNull
    public static String dump(@NotNull String directoryFilePath) {
        return ChronicleQueue.singleBuilder(directoryFilePath).build().dump();
    }

    private static WireOut intForBinding(ValueOut wireOut, LongValue value) {
        return value instanceof TwoLongValue ? wireOut.int128forBinding(0L, 0L, (TwoLongValue)value) : wireOut.int64forBinding(0L, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongValue loadWritePosition(@NotNull WireIn wire) {
        int code;
        ValueIn read = wire.read(MetaDataField.writePosition);
        long start = wire.bytes().readPosition();
        try {
            wire.consumePadding();
            code = wire.bytes().uncheckedReadUnsignedByte();
        }
        finally {
            wire.bytes().readPosition(start);
        }
        if (code == 141) {
            TwoLongValue result = wire.newTwoLongReference();
            read.int128(result);
            return result;
        }
        LongValue result = wire.newLongReference();
        read.int64(result);
        return result;
    }

    @Override
    @NotNull
    public File file() {
        return this.mappedFile.file();
    }

    @Override
    @NotNull
    public String dump() {
        return this.dump(false);
    }

    @Override
    @NotNull
    public String shortDump() {
        return this.dump(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dump(boolean abbrev) {
        MappedBytes bytes = MappedBytes.mappedBytes(this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs((Bytes)bytes, abbrev);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpHeader() {
        MappedBytes bytes = MappedBytes.mappedBytes(this.mappedFile);
        try {
            int size = bytes.readInt(0L);
            if (!Wires.isReady(size)) {
                String string = "not ready";
                return string;
            }
            bytes.readLimit(Wires.lengthOf(size) + 4);
            String string = Wires.fromSizePrefixedBlobs(bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    @NotNull
    public WireStore writePosition(long position) {
        assert (this.singleThreadedAccess());
        assert (this.writePosition.getVolatileValue() + this.mappedFile.chunkSize() > position);
        assert (Wires.isReadyData(this.mappedBytes.readVolatileInt(position)));
        this.writePosition.setMaxValue(position);
        return this;
    }

    @Override
    @Nullable
    public ScanResult moveToIndexForRead(@NotNull ExcerptContext ec, long index) {
        try {
            return this.indexing.moveToIndex(ec, index);
        }
        catch (UnrecoverableTimeoutException e) {
            return ScanResult.NOT_REACHED;
        }
    }

    @Override
    public long moveToEndForRead(@NotNull Wire w) {
        return this.indexing.moveToEnd(w);
    }

    @Override
    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    @Override
    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    @Override
    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public boolean tryReserve() {
        return this.refCount.tryReserve();
    }

    @Override
    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes(this.mappedFile);
    }

    @Override
    public long sequenceForPosition(@NotNull ExcerptContext ec, long position, boolean inclusive) throws UnrecoverableTimeoutException, StreamCorruptedException {
        return this.indexing.sequenceForPosition(ec, position, inclusive);
    }

    @Override
    public long lastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        return this.indexing.lastSequenceNumber(ec);
    }

    @NotNull
    public String toString() {
        return "SingleChronicleQueueStore{indexing=" + this.indexing + ", writePosition/seq=" + this.writePosition.toString() + ", mappedFile=" + this.mappedFile + ", refCount=" + this.refCount + '}';
    }

    private void onCleanup() {
        Closeable.closeQuietly((Object)this.writePosition);
        Closeable.closeQuietly((Object)this.indexing);
        this.mappedBytes.release();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        ValueOut wireOut = wire.write(MetaDataField.writePosition);
        SingleChronicleQueueStore.intForBinding(wireOut, this.writePosition).write(MetaDataField.indexing).typedMarshallable(this.indexing);
        wire.padToCacheAlign();
    }

    @Override
    public void initIndex(@NotNull Wire wire) {
        try {
            this.indexing.initIndex(wire);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean indexable(long index) {
        return this.indexing.indexable(index);
    }

    @Override
    public void setPositionForSequenceNumber(@NotNull ExcerptContext ec, long sequenceNumber, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
        this.sequence.setSequence(sequenceNumber, position);
        long nextSequence = this.indexing.nextEntryToBeIndexed();
        if (nextSequence > sequenceNumber) {
            return;
        }
        this.indexing.setPositionForSequenceNumber(ec, sequenceNumber, position);
    }

    @Override
    public ScanResult linearScanTo(long index, long knownIndex, ExcerptContext ec, long knownAddress) {
        return this.indexing.linearScanTo(index, knownIndex, ec, knownAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeEOF(@NotNull Wire wire, long timeoutMS) {
        String fileName = this.mappedFile.file().getAbsolutePath();
        if (wire.bytes().tryReserve()) {
            try {
                boolean bl2 = this.writeEOFAndShrink(wire, timeoutMS);
                return bl2;
            }
            finally {
                wire.bytes().release();
            }
        }
        try (MappedBytes bytes = MappedBytes.mappedBytes(this.mappedFile.file(), this.mappedFile.chunkSize());){
            Wire wire0 = (Wire)WireType.valueOf(wire).apply(bytes);
            boolean bl = this.writeEOFAndShrink(wire0, timeoutMS);
            return bl;
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "unable to write the EOF file=" + fileName, e);
            return false;
        }
    }

    boolean writeEOFAndShrink(@NotNull Wire wire, long timeoutMS) {
        if (wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, this.writePosition())) {
            QueueFileShrinkManager.scheduleShrinking(this.mappedFile.file(), wire.bytes().writePosition());
            System.out.println("Shrunk file " + this.mappedFile.file());
            return true;
        }
        return false;
    }

    int rollIndexCount() {
        return this.indexing.indexCount();
    }

    int rollIndexSpacing() {
        return this.indexing.indexSpacing();
    }

    private synchronized boolean singleThreadedAccess() {
        if (this.lastAccessedThread == null) {
            this.lastAccessedThread = Thread.currentThread();
        }
        return this.lastAccessedThread == Thread.currentThread();
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class);
    }
}

