/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.WireType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MoveToWrongIndexThenToEndTest {
    private static final int msgSize = 64;
    private static final int numOfToEndCalls = 100;
    private static final long noIndex = 0L;
    private static final RollCycle rollCycle = RollCycles.DAILY;
    private final Path basePath = Files.createTempDirectory("MoveToWrongIndexThenToEndTest", new FileAttribute[0]);
    private ExcerptAppender appender;
    private Bytes<ByteBuffer> outbound;

    public MoveToWrongIndexThenToEndTest() throws IOException {
        this.basePath.toFile().deleteOnExit();
        SingleChronicleQueue appenderChronicle = this.createChronicle(this.basePath);
        this.appender = appenderChronicle.acquireAppender();
        this.outbound = Bytes.elasticByteBuffer();
    }

    @After
    public void after() {
        this.outbound.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferUnderflowException() throws InterruptedException {
        this.append();
        this.append();
        long lastIndex = this.getLastIndex(this.basePath);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Semaphore l0 = new Semaphore(0);
            Semaphore l1 = new Semaphore(0);
            AtomicReference refThrowable = new AtomicReference();
            executor.execute(() -> {
                try (SingleChronicleQueue chronicle = this.createChronicle(this.basePath);){
                    ExcerptTailer tailer = chronicle.createTailer();
                    tailer.moveToIndex(lastIndex);
                    l0.release();
                    for (int i = 0; i < 100; ++i) {
                        tailer.toEnd();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    refThrowable.set(e);
                }
                finally {
                    l1.release();
                }
            });
            this.waitFor(l0, "tailer start");
            this.append();
            this.append();
            this.waitFor(l1, "tailer finish");
            Assert.assertNull((String)"refThrowable", refThrowable.get());
        }
        finally {
            try {
                executor.shutdown();
            }
            finally {
                if (!executor.isShutdown()) {
                    executor.shutdownNow();
                }
            }
        }
    }

    private void waitFor(Semaphore semaphore, String message) throws InterruptedException {
        boolean ok = semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)message, (boolean)ok);
    }

    private void append() {
        this.outbound.clear();
        this.outbound.write(new byte[64], 0, 64);
        this.appender.writeBytes(this.outbound);
    }

    private long getLastIndex(Path queuePath) {
        try (SingleChronicleQueue chronicle = this.createChronicle(queuePath);){
            SingleChronicleQueueExcerpts.StoreTailer tailer = new SingleChronicleQueueExcerpts.StoreTailer(chronicle);
            int firstCycle = chronicle.firstCycle();
            int lastCycle = chronicle.lastCycle();
            long lastKnownIndex = 0L;
            int numFiles = 0;
            if (firstCycle != Integer.MAX_VALUE && lastCycle != Integer.MIN_VALUE) {
                for (int cycle = firstCycle; cycle <= lastCycle; ++cycle) {
                    long lastIndex = this.approximateLastIndex(cycle, chronicle, tailer);
                    if (lastIndex == 0L) continue;
                    lastKnownIndex = lastIndex;
                    ++numFiles;
                }
            }
            if (numFiles <= 0) {
                throw new IllegalStateException("Missing Chronicle file for path " + chronicle.fileAbsolutePath());
            }
            long l = lastKnownIndex;
            return l;
        }
    }

    private long approximateLastIndex(int cycle, SingleChronicleQueue queue, SingleChronicleQueueExcerpts.StoreTailer tailer) {
        try {
            WireStore wireStore = queue.storeForCycle(cycle, queue.epoch(), false);
            if (wireStore == null) {
                return 0L;
            }
            long baseIndex = rollCycle.toIndex(cycle, 0L);
            tailer.moveToIndex(baseIndex);
            long seq = wireStore.sequenceForPosition((ExcerptContext)tailer, Long.MAX_VALUE, false);
            long sequenceNumber = seq + 1L;
            long index = rollCycle.toIndex(cycle, sequenceNumber);
            int cycleOfIndex = rollCycle.toCycle(index);
            if (cycleOfIndex != cycle) {
                throw new IllegalStateException("Expected cycle " + cycle + " but got " + cycleOfIndex);
            }
            return index;
        }
        catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private SingleChronicleQueue createChronicle(Path queuePath) {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.builder();
        builder.path(queuePath);
        builder.wireType(WireType.FIELDLESS_BINARY);
        builder.rollCycle(rollCycle);
        return builder.build();
    }
}

