/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class PretoucherTest {
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private final List<Integer> capturedCycles = new ArrayList<Integer>();
    private final CapturingChunkListener chunkListener = new CapturingChunkListener();

    private static SingleChronicleQueue createQueue(File path, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((File)path).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().wireType(WireType.BINARY).build();
    }

    @Ignore(value="flakey test see http://teamcity.higherfrequencytrading.com/repository/download/OpenHFT_ReleaseJob_ReleaseByArtifact/320311:id/ReleaseAutomation/projects/chronicle-queue-runTests-1548952667748.log")
    @Test
    public void shouldHandleCycleRoll() {
        File dir = DirectoryUtils.tempDir("shouldHandleCycleRoll");
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)i));
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    e.printStackTrace();
                }
                Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)(i + 1)));
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    e.printStackTrace();
                }
                Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)(i + 1)));
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(5L));
            });
            Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHandleEarlyCycleRoll() {
        Assume.assumeNotNull((Object[])new Object[]{OS.isWindows()});
        assert (System.getProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle") == null);
        assert (System.getProperty("SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs") == null);
        System.setProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle", "true");
        System.setProperty("SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs", "100");
        File dir = DirectoryUtils.tempDir("shouldHandleEarlyCycleRoll");
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(dir, this.clock::get);
             Pretoucher pretoucher = new Pretoucher(PretoucherTest.createQueue(dir, this.clock::get), (NewChunkListener)this.chunkListener, this.capturedCycles::add);){
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)(i == 0 ? 0 : i + 1)));
                    ctx.wire().write().int32(i);
                    ctx.wire().write().bytes(new byte[1024]);
                }
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    e.printStackTrace();
                }
                Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)(i + 1)));
                this.clock.addAndGet(950L);
                try {
                    pretoucher.execute();
                }
                catch (InvalidEventHandlerException e) {
                    e.printStackTrace();
                }
                this.clock.addAndGet(50L);
                Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)(i + 2)));
            });
            Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)11));
            Assert.assertThat((Object)this.chunkListener.chunkMap.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            System.clearProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle");
            System.clearProperty("SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs");
        }
    }

    private static final class CapturingChunkListener
    implements NewChunkListener {
        private final TreeMap<String, List<Integer>> chunkMap = new TreeMap();

        private CapturingChunkListener() {
        }

        public void onNewChunk(String filename, int chunk, long delayMicros) {
            this.chunkMap.computeIfAbsent(filename, f -> new ArrayList()).add(chunk);
        }
    }
}

