/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class NotCompleteTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsingANotCompleteQueue() throws InterruptedException {
        BinaryLongReference.startCollecting();
        File tmpDir = DirectoryUtils.tempDir("testUsingANotCompleteQueue");
        try {
            Throwable throwable;
            DocumentContext dc;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                ExcerptAppender appender = queue.acquireAppender();
                dc = appender.writingDocument();
                throwable = null;
                try {
                    dc.wire().write((CharSequence)"some").text("data");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                Thread.sleep(100L);
                BinaryLongReference.forceAllToNotCompleteState();
            }
            queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
            var3_3 = null;
            try {
                ExcerptTailer tailer = queue.createTailer();
                dc = tailer.readingDocument();
                throwable = null;
                try {
                    Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var3_3 = throwable6;
                throw throwable6;
            }
            finally {
                if (queue != null) {
                    if (var3_3 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable7) {
                            var3_3.addSuppressed(throwable7);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)tmpDir, (int)20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsingANotCompleteArrayQueue() throws InterruptedException {
        BinaryLongArrayReference.startCollecting();
        File tmpDir = DirectoryUtils.tempDir("testUsingANotCompleteArrayQueue");
        try {
            Throwable throwable;
            DocumentContext dc;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                ExcerptAppender appender = queue.acquireAppender();
                dc = appender.writingDocument();
                throwable = null;
                try {
                    dc.wire().write((CharSequence)"some").text("data");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                Thread.sleep(100L);
                BinaryLongArrayReference.forceAllToNotCompleteState();
            }
            queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
            var3_3 = null;
            try {
                ExcerptTailer tailer = queue.createTailer();
                dc = tailer.readingDocument();
                throwable = null;
                try {
                    Assert.assertEquals((Object)"data", (Object)dc.wire().read(() -> "some").text());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var3_3 = throwable6;
                throw throwable6;
            }
            finally {
                if (queue != null) {
                    if (var3_3 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable7) {
                            var3_3.addSuppressed(throwable7);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)tmpDir, (int)20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageNotLeftIncomplete() {
        File tmpDir = DirectoryUtils.tempDir("testMessageNotLeftIncomplete");
        try {
            Throwable throwable;
            DocumentContext dc;
            ExcerptAppender appender;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                appender = queue.acquireAppender();
                dc = appender.writingDocument();
                dc.wire().write((CharSequence)"some").text("data");
            }
            queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();
            var3_4 = null;
            try {
                ExcerptTailer tailer = queue.createTailer();
                dc = tailer.readingDocument();
                throwable = null;
                try {
                    Assert.assertFalse((boolean)dc.isPresent());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    0,\n    0\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 0\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0\n]\n...\n# 327292 bytes remaining\n";
                Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
            }
            catch (Throwable tailer) {
                var3_4 = tailer;
                throw tailer;
            }
            finally {
                if (queue != null) {
                    if (var3_4 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable tailer) {
                            var3_4.addSuppressed(tailer);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
            queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeoutMS(500L).build();
            var3_4 = null;
            try {
                appender = queue.acquireAppender();
                dc = appender.writingDocument();
                throwable = null;
                try {
                    dc.wire().write((CharSequence)"some").text("data");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
                String expected = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    384,\n    1649267441664\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 184,\n    lastIndex: 1\n  }\n}\n# position: 184, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  288,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 288, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  384,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 384, header: 0\n--- !!data #binary\nsome: data\n...\n" + (Jvm.isArm() ? "# 327276 bytes remaining\n" : "# 327278 bytes remaining\n");
                Assert.assertEquals((Object)expected, (Object)queue.dump());
            }
            catch (Throwable throwable6) {
                var3_4 = throwable6;
                throw throwable6;
            }
            finally {
                if (queue != null) {
                    if (var3_4 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable7) {
                            var3_4.addSuppressed(throwable7);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)tmpDir, (int)2);
            }
            catch (Exception e) {
                if (e instanceof AccessDeniedException && OS.isWindows()) {
                    return;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptedDuringSerialisation() throws InterruptedException {
        File tmpDir = DirectoryUtils.tempDir("testInterruptedDuringSerialisation");
        try {
            DirectoryUtils.deleteDir(tmpDir);
            tmpDir.mkdirs();
            List names = Collections.synchronizedList(new ArrayList());
            Person person1 = new Person(40, "Terry");
            Person interrupter = new Person(50, "Arthur");
            Person thrower = new Person(80, "Thrower");
            Person person2 = new Person(90, "Bert");
            try (SingleChronicleQueue queueReader = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeoutMS(500L).build();
                 SingleChronicleQueue queueWriter = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                String dump;
                ExcerptTailer tailer = queueReader.createTailer();
                MethodReader reader = tailer.methodReader(new Object[]{person -> names.add(person.name)});
                StringBuilder queueDumpBeforeInterruptedWrite = new StringBuilder();
                this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> {
                    proxy.accept(person1);
                    queueDumpBeforeInterruptedWrite.append(queue.dump());
                });
                String cleanedQueueDump = this.cleanQueueDump(queueDumpBeforeInterruptedWrite.toString());
                Thread writerThread = new Thread(() -> this.lambda$testInterruptedDuringSerialisation$5((ChronicleQueue)queueWriter, interrupter));
                writerThread.start();
                writerThread.join();
                try (SingleChronicleQueue queue2 = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
                    dump = this.cleanQueueDump(queue2.dump());
                    Assert.assertEquals((String)"queue should be unchanged by the interrupted write", (Object)cleanedQueueDump, (Object)dump);
                }
                Assert.assertTrue((boolean)reader.readOne());
                Assert.assertEquals((long)1L, (long)names.size());
                Assert.assertEquals((Object)person1.name, names.get(0));
                Assert.assertFalse((boolean)reader.readOne());
                this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> {
                    try {
                        proxy.accept(thrower);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                });
                queue2 = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();
                var17_22 = null;
                try {
                    dump = this.cleanQueueDump(queue2.dump());
                    Assert.assertEquals((String)"queue should be unchanged by the failed write", (Object)cleanedQueueDump, (Object)dump);
                    System.err.println(queue2.dump());
                }
                catch (Throwable dump2) {
                    var17_22 = dump2;
                    throw dump2;
                }
                finally {
                    if (queue2 != null) {
                        if (var17_22 != null) {
                            try {
                                queue2.close();
                            }
                            catch (Throwable dump2) {
                                var17_22.addSuppressed(dump2);
                            }
                        } else {
                            queue2.close();
                        }
                    }
                }
                Assert.assertFalse((boolean)reader.readOne());
                ExcerptAppender appender = queueWriter.acquireAppender();
                DocumentContext wd = appender.writingDocument();
                wd.rollbackOnClose();
                wd.close();
                dump = this.cleanQueueDump(queueWriter.dump());
                Assert.assertEquals((String)"queue should be unchanged by the failed write", (Object)cleanedQueueDump, (Object)dump);
                Assert.assertFalse((boolean)reader.readOne());
                this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> proxy.accept(person2));
                Assert.assertTrue((boolean)reader.readOne());
                Assert.assertEquals((long)2L, (long)names.size());
                Assert.assertEquals((Object)person2.name, names.get(1));
                Assert.assertFalse((boolean)reader.readOne());
            }
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)tmpDir, (int)2);
            }
            catch (Exception e) {
                if (e instanceof AccessDeniedException && OS.isWindows()) {
                    return;
                }
                throw e;
            }
        }
    }

    private String cleanQueueDump(String from) {
        return from.replaceAll("# [0-9]+ bytes remaining$", "");
    }

    private void doWrite(ChronicleQueue queue, BiConsumer<PersonListener, ChronicleQueue> action) {
        ExcerptAppender appender = queue.acquireAppender();
        PersonListener proxy = (PersonListener)appender.methodWriterBuilder(PersonListener.class).get();
        action.accept(proxy, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipSafeLengthOverBlock() {
        File tmpDir = DirectoryUtils.tempDir("testSkipSafeLengthOverBlock");
        try {
            for (int i = 0; i < 8; ++i) {
                try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeoutMS(1L).build();){
                    ExcerptAppender appender = queue.acquireAppender();
                    DocumentContext dc = appender.writingDocument();
                    dc.wire().write((CharSequence)"some").text("data");
                    continue;
                }
            }
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().build();){
                ExcerptTailer tailer = queue.createTailer();
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertFalse((boolean)dc.isPresent());
                }
            }
        }
        finally {
            IOTools.deleteDirWithFiles((File)tmpDir, (int)20);
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    private /* synthetic */ void lambda$testInterruptedDuringSerialisation$5(ChronicleQueue queueWriter, Person interrupter) {
        this.doWrite(queueWriter, (proxy, queue) -> proxy.accept(interrupter));
    }

    private class Person
    implements Marshallable {
        static final String INTERRUPT = "Arthur";
        static final String THROW = "Thrower";
        final int age;
        final String name;

        Person(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((CharSequence)"age").int32(this.age);
            if (INTERRUPT.equals(this.name)) {
                Thread.currentThread().interrupt();
            } else {
                if (THROW.equals(this.name)) {
                    throw new NullPointerException();
                }
                wire.write((CharSequence)"name").text(this.name);
            }
        }

        public String toString() {
            return "Person{age=" + this.age + ", name='" + this.name + '\'' + '}';
        }
    }

    private static interface PersonListener {
        public void accept(Person var1);
    }
}

