/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public final class MessageHistoryTest {
    @Rule
    public final TestName testName = new TestName();
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private File inputQueueDir;
    private File outputQueueDir;

    @Before
    public void setUp() throws Exception {
        this.inputQueueDir = DirectoryUtils.tempDir(this.testName.getMethodName());
        this.outputQueueDir = DirectoryUtils.tempDir(this.testName.getMethodName());
        VanillaMessageHistory messageHistory = new VanillaMessageHistory();
        messageHistory.addSourceDetails(true);
        MessageHistory.set((MessageHistory)messageHistory);
    }

    @Test
    public void shouldAccessMessageHistory() throws Exception {
        try (ChronicleQueue inputQueue = this.createQueue(this.inputQueueDir, 1);
             ChronicleQueue outputQueue = this.createQueue(this.outputQueueDir, 2);){
            this.generateTestData(inputQueue, outputQueue);
            ExcerptTailer tailer = outputQueue.createTailer();
            ValidatingSecond validatingSecond = new ValidatingSecond();
            MethodReader validator = tailer.methodReader(new Object[]{validatingSecond});
            Assert.assertThat((Object)validator.readOne(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)validatingSecond.messageHistoryPresent(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void shouldAccessMessageHistoryWhenTailerIsMovedToEnd() throws Exception {
        try (ChronicleQueue inputQueue = this.createQueue(this.inputQueueDir, 1);
             ChronicleQueue outputQueue = this.createQueue(this.outputQueueDir, 2);){
            this.generateTestData(inputQueue, outputQueue);
            ExcerptTailer tailer = outputQueue.createTailer();
            tailer.direction(TailerDirection.BACKWARD).toEnd();
            ValidatingSecond validatingSecond = new ValidatingSecond();
            MethodReader validator = tailer.methodReader(new Object[]{validatingSecond});
            Assert.assertThat((Object)validator.readOne(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)validatingSecond.messageHistoryPresent(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private void generateTestData(ChronicleQueue inputQueue, ChronicleQueue outputQueue) {
        First first = (First)inputQueue.acquireAppender().methodWriterBuilder(First.class).recordHistory(true).get();
        first.say("one");
        first.say("two");
        first.say("three");
        LoggingFirst loggingFirst = new LoggingFirst((Second)outputQueue.acquireAppender().methodWriterBuilder(Second.class).build());
        MethodReader reader = inputQueue.createTailer().methodReaderBuilder().build(new Object[]{loggingFirst});
        Assert.assertThat((Object)reader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)reader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        this.clock.addAndGet(TimeUnit.DAYS.toMillis(2L));
        Assert.assertThat((Object)reader.readOne(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)reader.readOne(), (Matcher)CoreMatchers.is((Object)false));
    }

    private ChronicleQueue createQueue(File queueDir, int sourceId) {
        return ChronicleQueue.singleBuilder((File)queueDir).sourceId(sourceId).timeProvider(this.clock::get).testBlockSize().build();
    }

    private static class ValidatingSecond
    implements Second {
        private boolean messageHistoryPresent = false;

        private ValidatingSecond() {
        }

        @Override
        public void count(int value) {
            MessageHistory messageHistory = MessageHistory.get();
            Assert.assertNotNull((Object)messageHistory);
            Assert.assertThat((Object)messageHistory.sources(), (Matcher)CoreMatchers.is((Object)2));
            this.messageHistoryPresent = true;
        }

        boolean messageHistoryPresent() {
            return this.messageHistoryPresent;
        }
    }

    private static final class LoggingFirst
    implements First {
        private final Second second;

        private LoggingFirst(Second second) {
            this.second = second;
        }

        @Override
        public void say(String word) {
            this.second.count(word.length());
        }
    }

    @FunctionalInterface
    static interface Second {
        public void count(int var1);
    }

    @FunctionalInterface
    static interface First {
        public void say(String var1);
    }
}

