/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadmeTest {
    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.threadDump.ignore("disk-space-checker");
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void createAQueue() {
        String basePath = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((String)basePath).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(w -> w.write(() -> "msg").text("TestMessage"));
            appender.writeText((CharSequence)"TestMessage");
            ExcerptTailer tailer = queue.createTailer();
            tailer.readDocument(w -> System.out.println("msg: " + w.read(() -> "msg").text()));
            Assert.assertEquals((Object)"TestMessage", (Object)tailer.readText());
        }
    }

    @After
    public void checkRegisteredBytes() {
        BytesUtil.checkRegisteredBytes();
    }
}

