/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleQueuePeekDocumentTest {
    boolean firstMessage = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsingPeekDocument() throws IOException {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("ChronicleQueueLoggerTest", new FileAttribute[0]);
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)tempDir).build();){
                ExcerptTailer tailer = queue.createTailer();
                try (SingleChronicleQueue writeQueue = SingleChronicleQueueBuilder.binary((Path)tempDir).build();){
                    ExcerptAppender appender = writeQueue.acquireAppender();
                    try (DocumentContext dc = appender.writingDocument();){
                        dc.wire().write((CharSequence)"field1").int32(123534).write((CharSequence)"field2").float64(123.423).write((CharSequence)"time").int64(12053432432L);
                    }
                    dc = appender.writingDocument();
                    var9_13 = null;
                    try {
                        dc.wire().write((CharSequence)"field1").int32(323242).write((CharSequence)"field2").float64(543.1233).write((CharSequence)"time").int64(12053432900L);
                    }
                    catch (Throwable throwable) {
                        var9_13 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (dc != null) {
                            if (var9_13 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable) {
                                    var9_13.addSuppressed(throwable);
                                }
                            } else {
                                dc.close();
                            }
                        }
                    }
                }
                Assert.assertEquals((Object)"field1: !int 123534\nfield2: 123.423\ntime: 12053432432\n", (Object)this.read(tailer));
                Assert.assertEquals((Object)"field1: !int 323242\nfield2: 543.1233\ntime: 12053432900\n", (Object)this.read(tailer));
            }
        }
        finally {
            if (tempDir != null) {
                IOTools.deleteDirWithFiles((File)tempDir.toFile(), (int)2);
            }
        }
    }

    private String read(ExcerptTailer tailer) {
        if (tailer.peekDocument() || this.firstMessage) {
            try (DocumentContext dc = tailer.readingDocument(false);){
                if (dc.isPresent()) {
                    String text;
                    this.firstMessage = false;
                    String string = text = dc.wire().asText().toString();
                    return string;
                }
            }
        }
        return null;
    }
}

