/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.pretoucher;

import java.util.UUID;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.pretoucher.Monitor;
import net.openhft.chronicle.queue.impl.single.pretoucher.ValidFields;
import net.openhft.chronicle.queue.impl.single.pretoucher.Validatable;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.MessageHistory;

public class PretoucherSoakTest {
    public static void main(String[] args) {
        SingleChronicleQueue outQueue = SingleChronicleQueueBuilder.binary((String)"target/monitor").rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();
        ExcerptAppender outQueueAppender = outQueue.acquireAppender();
        HeartbeatListener heartbeatWriter = (HeartbeatListener)outQueueAppender.methodWriterBuilder(HeartbeatListener.class).methodWriterListener((m, a) -> ValidFields.validateAll(a)).get();
        Monitor.addPeriodicUpdateSource(10L, () -> currentTimeMillis -> outQueueAppender.pretouch());
        long lastHB = 0L;
        while (true) {
            if (System.currentTimeMillis() - lastHB <= 1L) {
                continue;
            }
            MessageHistory.get().reset();
            Heartbeat heartBeat = new Heartbeat(UUID.randomUUID().toString());
            heartbeatWriter.heartbeat(heartBeat);
            lastHB = System.currentTimeMillis();
        }
    }

    public static class Heartbeat
    extends AbstractMarshallable
    implements Validatable {
        final String source;
        long time;

        public Heartbeat(String source) {
            this.source = source;
        }

        public String source() {
            return this.source;
        }

        public long time() {
            return this.time;
        }

        public Heartbeat time(long time) {
            this.time = time;
            return this;
        }

        @Override
        public void validate() throws IllegalStateException {
        }
    }

    public static interface HeartbeatListener {
        public void heartbeat(Heartbeat var1);
    }
}

