/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.AbstractMarshallable;
import org.junit.Assert;
import org.junit.Test;

public class ProxyTest {
    @Test
    public void testReadWrite() {
        File tempDir = DirectoryUtils.tempDir("to-be-deleted");
        final StringBuilder result = new StringBuilder();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            TestMessageListener writer = (TestMessageListener)queue.acquireAppender().methodWriterBuilder(TestMessageListener.class).build();
            Message message = new Message();
            StringBuilder sb = new StringBuilder("test ");
            int length = sb.length();
            for (int i = 0; i < 10; ++i) {
                sb.append(i);
                message.message(sb);
                writer.onMessage(message);
                sb.setLength(length);
            }
            MethodReader methodReader = queue.createTailer().methodReader(new Object[]{new TestMessageListener(){

                @Override
                public void onMessage(Message message) {
                    result.append((Object)message);
                }
            }});
            for (int i = 0; i < 10; ++i) {
                methodReader.readOne();
            }
        }
        Assert.assertEquals((Object)"!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 0\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 1\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 2\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 3\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 4\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 5\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 6\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 7\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 8\n}\n!net.openhft.chronicle.queue.ProxyTest$Message {\n  message: test 9\n}\n", (Object)result.toString());
    }

    public static class Message
    extends AbstractMarshallable {
        private final StringBuilder message = new StringBuilder();

        CharSequence message() {
            return this.message;
        }

        Message message(CharSequence message) {
            this.message.setLength(0);
            this.message.append(message);
            return this;
        }
    }

    public static interface TestMessageListener {
        public void onMessage(Message var1);
    }

    public static class MyProxy
    implements TestMessageListener {
        static Object[] a1 = null;
        static Method m1 = null;
        private final Object proxy;
        private final InvocationHandler handler;

        public MyProxy(Object proxy, InvocationHandler handler) {
            this.proxy = proxy;
            this.handler = handler;
        }

        @Override
        public void onMessage(Message message) {
            MyProxy.a1[0] = message;
            try {
                this.handler.invoke(this.proxy, m1, a1);
            }
            catch (Throwable throwable) {
                Jvm.rethrow((Throwable)throwable);
            }
        }

        static {
            try {
                m1 = MyProxy.class.getMethod("onMessage", Message.class);
                a1 = new Object[m1.getParameterTypes().length];
            }
            catch (NoSuchMethodException e) {
                Jvm.rethrow((Throwable)e);
            }
        }
    }
}

