/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderBuilder;
import net.openhft.chronicle.bytes.MethodReaderInterceptor;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMethodReader;
import net.openhft.chronicle.wire.WireParselet;
import org.jetbrains.annotations.NotNull;

public class VanillaMethodReaderBuilder
implements MethodReaderBuilder {
    private final MarshallableIn in;
    private boolean warnMissing = false;
    private boolean ignoreDefaults;
    private WireParselet defaultParselet;
    private MethodReaderInterceptor methodReaderInterceptor;

    public VanillaMethodReaderBuilder(MarshallableIn in) {
        this.in = in;
    }

    @NotNull
    public static WireParselet createDefaultParselet(boolean warnMissing) {
        return (s, v) -> {
            MessageHistory history = MessageHistory.get();
            long sourceIndex = history.lastSourceIndex();
            v.skipValue();
            if (s.length() == 0 || warnMissing) {
                VanillaMethodReader.LOGGER.warn(VanillaMethodReaderBuilder.errorMsg(s, history, sourceIndex));
            } else if (VanillaMethodReader.LOGGER.isDebugEnabled()) {
                VanillaMethodReader.LOGGER.debug(VanillaMethodReaderBuilder.errorMsg(s, history, sourceIndex));
            }
        };
    }

    @NotNull
    private static String errorMsg(CharSequence s, MessageHistory history, long sourceIndex) {
        String identifierType = s.length() != 0 && Character.isDigit(s.charAt(0)) ? "@MethodId" : "method-name";
        return "Unknown " + identifierType + "='" + s + "' from " + history.lastSourceId() + " at " + Long.toHexString(sourceIndex) + " ~ " + (int)sourceIndex;
    }

    public boolean ignoreDefaults() {
        return this.ignoreDefaults;
    }

    @NotNull
    public MethodReaderBuilder ignoreDefaults(boolean ignoreDefaults) {
        this.ignoreDefaults = ignoreDefaults;
        return this;
    }

    public WireParselet defaultParselet() {
        return this.defaultParselet;
    }

    public MethodReaderBuilder defaultParselet(WireParselet defaultParselet) {
        this.defaultParselet = defaultParselet;
        return this;
    }

    @Override
    public MethodReaderBuilder methodReaderInterceptor(MethodReaderInterceptor methodReaderInterceptor) {
        this.methodReaderInterceptor = methodReaderInterceptor;
        return this;
    }

    public boolean warnMissing() {
        return this.warnMissing;
    }

    @Override
    public VanillaMethodReaderBuilder warnMissing(boolean warnMissing) {
        this.warnMissing = warnMissing;
        return this;
    }

    @Override
    @NotNull
    public MethodReader build(Object ... impls) {
        WireParselet defaultParselet = this.defaultParselet;
        if (defaultParselet == null) {
            defaultParselet = VanillaMethodReaderBuilder.createDefaultParselet(this.warnMissing);
        }
        return new VanillaMethodReader(this.in, this.ignoreDefaults, defaultParselet, this.methodReaderInterceptor, impls);
    }
}

