/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cooler;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.locks.LockSupport;
import net.openhft.affinity.Affinity;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.cooler.CpuCooler;

public enum CpuCoolers implements CpuCooler
{
    PARK{

        @Override
        public void disturb() {
            LockSupport.parkNanos(200000L);
        }
    }
    ,
    PAUSE1{

        @Override
        public void disturb() {
            Jvm.pause(1L);
        }
    }
    ,
    PAUSE3{

        @Override
        public void disturb() {
            Jvm.pause(3L);
        }
    }
    ,
    PAUSE6{

        @Override
        public void disturb() {
            Jvm.pause(6L);
        }
    }
    ,
    PAUSE10{

        @Override
        public void disturb() {
            Jvm.pause(10L);
        }
    }
    ,
    PAUSE100{

        @Override
        public void disturb() {
            Jvm.pause(100L);
        }
    }
    ,
    YIELD{

        @Override
        public void disturb() {
            Thread.yield();
        }
    }
    ,
    BUSY{

        @Override
        public void disturb() {
            8.busyWait(100000.0);
        }
    }
    ,
    BUSY10{

        @Override
        public void disturb() {
            9.busyWait(1.0E7);
        }
    }
    ,
    BUSY25{

        @Override
        public void disturb() {
            10.busyWait(2.5E7);
        }
    }
    ,
    BUSY35{

        @Override
        public void disturb() {
            11.busyWait(3.5E7);
        }
    }
    ,
    BUSY50{

        @Override
        public void disturb() {
            12.busyWait(5.0E7);
        }
    }
    ,
    BUSY70{

        @Override
        public void disturb() {
            13.busyWait(5.0E7);
        }
    }
    ,
    BUSY100{

        @Override
        public void disturb() {
            14.busyWait(1.0E8);
        }
    }
    ,
    BUSY300{

        @Override
        public void disturb() {
            15.busyWait(3.0E8);
        }
    }
    ,
    BUSY1000{

        @Override
        public void disturb() {
            16.busyWait(1.0E9);
        }
    }
    ,
    AFFINITY{
        boolean toogle;

        @Override
        public void disturb() {
            Affinity.setAffinity(this.toogle ? 3 : 4);
            this.toogle = !this.toogle;
        }
    }
    ,
    SERIALIZATION{

        @Override
        public void disturb() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLEncoder oos = new XMLEncoder(out);
            oos.writeObject(System.getProperties());
            oos.close();
            XMLDecoder ois = new XMLDecoder(new ByteArrayInputStream(out.toByteArray()));
            blackhole = ois.readObject();
        }
    }
    ,
    MEMORY_COPY{
        long[] from = new long[0x800000];
        long[] to = new long[0x800000];

        @Override
        public void disturb() {
            System.arraycopy(this.from, 0, this.to, 0, this.from.length);
        }
    }
    ,
    ALL{

        @Override
        public void disturb() {
            SERIALIZATION.disturb();
            MEMORY_COPY.disturb();
            PAUSE10.disturb();
        }
    };

    static volatile Object blackhole;

    public static void busyWait(double nanos) {
        long start = System.nanoTime();
        while ((double)(System.nanoTime() - start) < nanos) {
        }
    }
}

