/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OffsetFormat;
import net.openhft.chronicle.bytes.RandomDataInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HexDumpBytes
implements Bytes<Void> {
    private static final char[] HEXADECIMAL = "0123456789abcdef".toCharArray();
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]{1,2}");
    private final NativeBytes<Void> base = Bytes.allocateElasticDirect(128L);
    private final Bytes<ByteBuffer> text = Bytes.elasticHeapByteBuffer(512);
    private final Bytes<ByteBuffer> comment = Bytes.elasticHeapByteBuffer(64);
    private OffsetFormat offsetFormat = null;
    private long startOfLine = 0L;
    private int indent = 0;
    private int numberWrap = 16;

    public HexDumpBytes() {
    }

    HexDumpBytes(BytesStore base, Bytes text) {
        try {
            this.base.write(base);
            this.text.write(text);
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HexDumpBytes fromText(Reader reader) {
        HexDumpBytes tb = new HexDumpBytes();
        TextBytesReader reader2 = new TextBytesReader(reader, tb.text);
        try (Scanner sc = new Scanner(reader2);){
            while (sc.hasNext()) {
                if (sc.hasNext(HEX_PATTERN)) {
                    tb.base.writeUnsignedByte(Integer.parseInt(sc.next(), 16));
                    continue;
                }
                sc.nextLine();
            }
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return tb;
    }

    public static HexDumpBytes fromText(CharSequence text) {
        return HexDumpBytes.fromText(new StringReader(text.toString()));
    }

    public HexDumpBytes offsetFormat(OffsetFormat offsetFormat) {
        this.offsetFormat = offsetFormat;
        return this;
    }

    public int numberWrap() {
        return this.numberWrap;
    }

    public HexDumpBytes numberWrap(int numberWrap) {
        this.numberWrap = numberWrap;
        return this;
    }

    @Override
    public long readRemaining() {
        return this.base.readRemaining();
    }

    @Override
    public long writeRemaining() {
        return this.base.writeRemaining();
    }

    @Override
    public long readLimit() {
        return this.base.readLimit();
    }

    @Override
    public long writeLimit() {
        return this.base.writeLimit();
    }

    @Override
    @NotNull
    public String toHexString() {
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this.text.toString();
    }

    @Override
    public boolean retainsComments() {
        return true;
    }

    @Override
    public Bytes<Void> comment(CharSequence comment) {
        if (this.comment.readRemaining() > 0L || comment.length() == 0) {
            this.newLine();
        }
        if (comment.length() > 0 && comment.charAt(0) == '#') {
            this.indent = 0;
            ((Bytes)((Bytes)this.text.append('#')).append(comment)).append('\n');
            this.startOfLine = this.text.writePosition();
        } else {
            this.comment.clear().append(comment);
        }
        return this;
    }

    @Override
    public BytesOut indent(int n) {
        this.indent += n;
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this;
    }

    private long lineLength() {
        return this.text.writePosition() - this.startOfLine;
    }

    private void newLine() {
        if (this.comment.readRemaining() > 0L) {
            while (this.lineLength() < (long)(this.numberWrap * 3 - 3)) {
                this.text.append("   ");
            }
            while (this.lineLength() < (long)(this.numberWrap * 3)) {
                this.text.append(' ');
            }
            this.text.append("# ");
            this.text.append(this.comment);
            this.comment.clear();
        }
        this.text.append('\n');
        this.startOfLine = this.text.writePosition();
    }

    private void appendOffset(long offset) {
        if (this.offsetFormat == null) {
            return;
        }
        this.offsetFormat.append(offset, this.text);
        long wp = this.text.writePosition();
        if (wp > 0L && this.text.peekUnsignedByte(wp - 1L) > 32) {
            this.text.append(' ');
        }
        this.startOfLine = this.text.writePosition();
    }

    @Override
    public BytesStore copy() {
        return new HexDumpBytes(this.base, this.text);
    }

    @Override
    public boolean isElastic() {
        return this.base.isElastic();
    }

    @Override
    public void ensureCapacity(long size) throws IllegalArgumentException {
        this.base.ensureCapacity(size);
    }

    @Override
    @NotNull
    public BytesStore bytesStore() {
        return this.base;
    }

    @Override
    @NotNull
    public Bytes compact() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes clear() {
        return this.base.clear();
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    public long capacity() {
        return this.base.capacity();
    }

    @Override
    public long addressForRead(long offset) throws UnsupportedOperationException {
        return this.base.addressForRead(offset);
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException {
        if (this.base.compareAndSwapInt(offset & 0xFFFFFFFFL, expected, value)) {
            this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
            return true;
        }
        return false;
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) {
        long off = offset & 0xFFFFFFFFL;
        this.base.testAndSetInt(off, expected, value);
        this.copyToText(off, offset >>> 32, 4);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException {
        if (this.base.compareAndSwapLong(offset & 0xFFFFFFFFL, expected, value)) {
            this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Void underlyingObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(long from, long to, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reserve() throws IllegalStateException {
        this.base.reserve();
        this.text.reserve();
    }

    @Override
    public void release() throws IllegalStateException {
        this.base.release();
        this.text.release();
    }

    @Override
    public long refCount() {
        return this.base.refCount();
    }

    @Override
    public boolean tryReserve() {
        this.text.tryReserve();
        return this.base.tryReserve();
    }

    @Override
    @NotNull
    public Bytes<Void> writeByte(long offset, byte i8) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeShort(long offset, short i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeInt24(long offset, int i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeInt(long offset, int i) throws BufferOverflowException {
        return this.writeOrderedInt(offset, i);
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(long offset, int i) throws BufferOverflowException {
        this.base.writeOrderedInt(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeLong(long offset, long i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeFloat(long offset, float d) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeDouble(long offset, double d) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> write(long writeOffset, RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, IllegalArgumentException, BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> readPosition(long position) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> readLimit(long limit) throws BufferUnderflowException {
        this.base.readLimit(limit);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> readSkip(long bytesToSkip) throws BufferUnderflowException {
        this.base.readSkip(bytesToSkip);
        return this;
    }

    @Override
    public void uncheckedReadSkipOne() {
        this.base.uncheckedReadSkipOne();
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        this.base.uncheckedReadSkipBackOne();
    }

    @Override
    public byte readByte() {
        return this.base.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.base.readUnsignedByte();
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        return this.base.uncheckedReadUnsignedByte();
    }

    @Override
    public short readShort() throws BufferUnderflowException {
        return this.base.readShort();
    }

    @Override
    public int readInt() throws BufferUnderflowException {
        return this.base.readInt();
    }

    @Override
    public long readLong() throws BufferUnderflowException {
        return this.base.readLong();
    }

    @Override
    public float readFloat() throws BufferUnderflowException {
        return this.base.readFloat();
    }

    @Override
    public double readDouble() throws BufferUnderflowException {
        return this.base.readDouble();
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException {
        return this.base.readVolatileInt();
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException {
        return this.base.readVolatileLong();
    }

    @Override
    public int peekUnsignedByte() {
        return this.base.peekUnsignedByte();
    }

    @Override
    public void nativeRead(long address, long size) throws BufferUnderflowException {
        this.base.nativeRead(address, size);
    }

    @Override
    public int lastDecimalPlaces() {
        return this.base.lastDecimalPlaces();
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.base.lastDecimalPlaces(lastDecimalPlaces);
    }

    @Override
    @NotNull
    public Bytes<Void> writePosition(long position) throws BufferOverflowException {
        this.base.writePosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeLimit(long limit) throws BufferOverflowException {
        this.base.writeLimit(limit);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSkip(bytesToSkip);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeByte(byte i8) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeByte(i8);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public long writePosition() {
        return this.base.writePosition() | this.text.writePosition() << 32;
    }

    private void copyToText(long pos) {
        long end;
        if (this.lineLength() == 0L && this.offsetFormat != null) {
            this.appendOffset(pos);
            this.startOfLine = this.text.writePosition();
        }
        if (pos < (end = this.base.writePosition())) {
            this.doIndent();
            do {
                int value = this.base.readUnsignedByte(pos);
                long ll = this.lineLength();
                if (ll >= (long)(this.numberWrap * 3 - 1)) {
                    this.newLine();
                    this.appendOffset(pos);
                    this.doIndent();
                    this.startOfLine = this.text.writePosition();
                }
                ++pos;
                long wp = this.text.writePosition();
                if (wp > 0L && this.text.peekUnsignedByte(wp - 1L) > 32) {
                    this.text.append(' ');
                }
                this.text.appendBase16(value, 2);
            } while (pos < end);
        }
    }

    private void copyToText(long pos, long tpos, int length) {
        if (tpos > 0L && this.text.readUnsignedByte(tpos) <= 32) {
            ++tpos;
        }
        while (length-- > 0) {
            int value = this.base.readUnsignedByte(pos++);
            this.text.writeUnsignedByte(tpos++, HEXADECIMAL[value >> 4]);
            this.text.writeUnsignedByte(tpos++, HEXADECIMAL[value & 0xF]);
            if (length <= 0) continue;
            this.text.writeUnsignedByte(tpos++, 32);
        }
    }

    private void doIndent() {
        if (this.lineLength() == 0L && this.indent > 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.text.append("   ");
            }
            this.startOfLine = this.text.writePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeShort(short i16) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeShort(i16);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeInt(int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeIntAdv(int i, int advance) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeIntAdv(i, advance);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeLong(long i64) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeLong(i64);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeLongAdv(long i64, int advance) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeLongAdv(i64, advance);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeFloat(float f) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeFloat(f);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeDouble(double d) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeDouble(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeDoubleAndInt(double d, int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeDouble(d);
            this.base.writeInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public long realWriteRemaining() {
        return this.base.realWriteRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSome(ByteBuffer buffer) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSome(buffer);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(int i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeOrderedInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeOrderedLong(long i) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeOrderedLong(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nativeWrite(long address, long size) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.nativeWrite(address, size);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> clearAndPad(long length) throws BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.clearAndPad(length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> prewrite(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewrite(BytesStore bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteByte(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteShort(short i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteInt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteLong(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        return this.base.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(long offset) {
        return this.base.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        return this.base.readShort(offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        return this.base.readInt(offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        return this.base.readLong(offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        return this.base.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        return this.base.readDouble(offset);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        return this.base.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        return this.base.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        return this.base.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        return this.base.readVolatileLong(offset);
    }

    @Override
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException {
        this.base.nativeRead(position, address, size);
    }

    @Override
    public long readPosition() {
        return this.base.readPosition() | this.text.readPosition() << 32;
    }

    @Override
    public void lenient(boolean lenient) {
        this.base.lenient(lenient);
    }

    @Override
    public boolean lenient() {
        return this.base.lenient();
    }

    private static class TextBytesReader
    extends Reader {
        private final Reader reader;
        private final Bytes base;

        public TextBytesReader(Reader reader, Bytes base) {
            this.reader = reader;
            this.base = base;
        }

        @Override
        public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
            int len2 = this.reader.read(cbuf, off, len);
            this.base.append(new String(cbuf, off, len));
            return len2;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

