/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Writer;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringWriter;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.UnsafeText;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    @NotNull
    default public Writer writer() {
        return new ByteStringWriter(this);
    }

    @NotNull
    default public B append(char ch) throws BufferOverflowException {
        BytesInternal.appendUtf8Char(this, ch);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) throws BufferOverflowException {
        try {
            return (B)this.append(cs, 0, cs.length());
        }
        catch (IndexOutOfBoundsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public B append(boolean flag) throws BufferOverflowException {
        return (B)this.append(flag ? (char)'T' : 'F');
    }

    @NotNull
    default public B append(int value) throws BufferOverflowException {
        BytesInternal.appendBase10(this, value);
        return (B)this;
    }

    @NotNull
    default public B append(long value) throws BufferOverflowException {
        if (value == (long)((int)value)) {
            BytesInternal.appendBase10(this, (int)value);
        } else {
            BytesInternal.appendBase10(this, value);
        }
        return (B)this;
    }

    @NotNull
    default public B appendBase(long value, int base) throws BufferOverflowException {
        BytesInternal.append(this, value, base);
        return (B)this;
    }

    @NotNull
    default public B appendBase16(long value) throws BufferOverflowException {
        BytesInternal.appendBase16(this, value, 1);
        return (B)this;
    }

    @NotNull
    default public B appendBase16(long value, int minDigits) throws BufferOverflowException {
        BytesInternal.appendBase16(this, value, minDigits);
        return (B)this;
    }

    @NotNull
    default public B appendDecimal(long value, int decimalPlaces) throws BufferOverflowException {
        BytesInternal.appendDecimal(this, value, decimalPlaces);
        return (B)this;
    }

    @NotNull
    default public B append(float f) throws BufferOverflowException {
        float f2 = Math.abs(f);
        if ((double)f2 > 1000000.0 || (double)f2 < 0.001) {
            return (B)this.append(Float.toString(f));
        }
        int precision = (int)Math.floor(6.0 - Math.log10(f2));
        long tens = Maths.tens(precision);
        return this.append((double)Math.round(f * (float)tens) / (double)tens);
    }

    @NotNull
    default public B append(double d) throws BufferOverflowException {
        BytesInternal.append(this, d);
        return (B)this;
    }

    @NotNull
    default public B append(double d, int decimalPlaces) throws BufferOverflowException {
        double d2;
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException();
        }
        if (decimalPlaces < 20 && (d2 = d * (double)Maths.tens(decimalPlaces)) < 9.223372036854776E18 && d2 > -9.223372036854776E18) {
            long round;
            long l = round = d2 > 0.0 ? (long)(d2 + 0.5) : (long)(d2 - 0.5);
            if (this.canWriteDirect(20 + decimalPlaces)) {
                long address = this.addressForWritePosition();
                long address2 = UnsafeText.appendBase10d(address, round, decimalPlaces);
                this.writeSkip(address2 - address);
            } else {
                this.appendDecimal(round, decimalPlaces);
            }
            return (B)this;
        }
        return this.append(d);
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, int start, int end) throws IndexOutOfBoundsException, BufferOverflowException {
        BytesInternal.appendUtf8(this, cs, start, end - start);
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        return this.append8bit(cs, 0, cs.length());
    }

    default public B append8bit(@NotNull BytesStore bs) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        return (B)((ByteStringAppender)this.write(bs, 0L, bs.readRemaining()));
    }

    default public B append8bit(@NotNull String cs) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        return this.append8bit(cs, 0, cs.length());
    }

    default public B append8bit(@NotNull CharSequence cs, int start, int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs, (long)start, (long)end));
        }
        for (int i = start; i < end; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte((byte)c);
        }
        return (B)this;
    }

    default public B append8bit(@NotNull BytesStore bs, long start, long end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        return (B)((ByteStringAppender)this.write(bs, start, end));
    }

    @NotNull
    default public B appendDateMillis(long dateInMillis) {
        BytesInternal.appendDateMillis(this, dateInMillis);
        return (B)this;
    }

    @NotNull
    default public B appendTimeMillis(long timeOfDayInMillis) {
        BytesInternal.appendTimeMillis(this, timeOfDayInMillis % 86400000L);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull BigDecimal bigDecimal) {
        this.append(bigDecimal.toString());
        return (B)this;
    }
}

