/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableStore;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class SingleTableBuilder<T extends Metadata> {
    @NotNull
    private final File file;
    @NotNull
    private T metadata;
    private WireType wireType;
    private boolean readOnly;
    private boolean validateMetadata;
    private StoreRecoveryFactory recoverySupplier = TimedStoreRecovery.FACTORY;
    private long timeoutMS = TimeUnit.SECONDS.toMillis(5L);

    private SingleTableBuilder(@NotNull File path, @NotNull T metadata) {
        this.file = path;
        this.metadata = metadata;
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> builder(@NotNull File file, @NotNull WireType wireType, @NotNull T metadata) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Tables should be configured with the table file, not a directory. Actual file used: " + file.getParentFile());
        }
        if (!file.getName().endsWith(".cq4t")) {
            throw new IllegalArgumentException("Invalid file type: " + file.getName());
        }
        return new SingleTableBuilder<T>(file, metadata).wireType(wireType);
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> binary(@NotNull Path path, @NotNull T metadata) {
        return SingleTableBuilder.binary(path.toFile(), metadata);
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> binary(@NotNull String file, @NotNull T metadata) {
        return SingleTableBuilder.binary(new File(file), metadata);
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> binary(@NotNull File basePathFile, @NotNull T metadata) {
        return SingleTableBuilder.builder(basePathFile, WireType.BINARY_LIGHT, metadata);
    }

    @NotNull
    public TableStore<T> build() {
        if (this.readOnly && !this.file.exists()) {
            throw new IORuntimeException("File not found in readOnly mode");
        }
        try {
            if (!this.readOnly && this.file.createNewFile() && !this.file.canWrite()) {
                throw new IllegalStateException("Cannot write to tablestore file " + this.file);
            }
            MappedBytes bytes = MappedBytes.mappedBytes(this.file, 65536L, 0L, this.readOnly);
            bytes.readVolatileInt(0L);
            Wire wire = (Wire)this.wireType.apply(bytes);
            StoreRecovery recovery = (StoreRecovery)this.recoverySupplier.apply(this.wireType);
            return SingleTableStore.doWithExclusiveLock(this.file, v -> {
                try {
                    if (!this.readOnly && wire.writeFirstHeader()) {
                        return this.writeTableStore(bytes, wire, recovery);
                    }
                    wire.readFirstHeader(this.timeoutMS, TimeUnit.MILLISECONDS);
                    StringBuilder name = Wires.acquireStringBuilder();
                    ValueIn valueIn = wire.readEventName(name);
                    if (StringUtils.isEqual(name, MetaDataKeys.header.name())) {
                        TableStore existing = (TableStore)Objects.requireNonNull(valueIn.typedMarshallable());
                        if (this.validateMetadata) {
                            this.metadata.ensureSame(existing.metadata());
                        } else {
                            this.metadata = existing.metadata();
                        }
                        return existing;
                    }
                    throw new StreamCorruptedException("The first message should be the header, was " + name);
                }
                catch (IOException ex) {
                    throw Jvm.rethrow(ex);
                }
                catch (TimeoutException ex) {
                    recovery.recoverAndWriteHeader(wire, 10000L, null, null);
                    return this.writeTableStore(bytes, wire, recovery);
                }
            }, () -> null);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @NotNull
    private TableStore<T> writeTableStore(MappedBytes bytes, Wire wire, StoreRecovery recovery) {
        SingleTableStore<T> store = new SingleTableStore<T>(this.wireType, bytes, recovery, this.metadata);
        wire.writeEventName("header").object(store);
        wire.updateFirstHeader();
        return store;
    }

    @NotNull
    public SingleTableBuilder<T> clone() {
        try {
            SingleTableBuilder clone = (SingleTableBuilder)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public File file() {
        return this.file;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public SingleTableBuilder<T> wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public SingleTableBuilder<T> readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public SingleTableBuilder<T> validateMetadata(boolean validateMetadata) {
        this.validateMetadata = validateMetadata;
        return this;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public SingleTableBuilder<T> recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        this.recoverySupplier = recoverySupplier;
        return this;
    }

    public long timeoutMS() {
        return this.timeoutMS;
    }

    public SingleTableBuilder<T> timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(WireType.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleTableStore.class, "STStore");
        ClassAliasPool.CLASS_ALIASES.addAlias(TimedStoreRecovery.class);
    }
}

