/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.NoopQueueLock;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.single.ReadOnlyWriteLock;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQMeta;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TSQueueLock;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.ReadonlyTableStore;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueBuilder<S extends SingleChronicleQueueBuilder>
extends AbstractChronicleQueueBuilder<SingleChronicleQueueBuilder<S>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleChronicleQueueBuilder.class);
    protected TableStore<SCQMeta> metaStore;

    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull String path) {
        this(new File(path));
    }

    @Deprecated
    public SingleChronicleQueueBuilder(@NotNull File path) {
        super(path);
        this.storeFactory(SingleChronicleQueueBuilder::createStore);
    }

    public static void addAliases() {
    }

    public static void init() {
    }

    @NotNull
    public static <S extends SingleChronicleQueueBuilder<S>> SingleChronicleQueueBuilder<S> builder(@NotNull Path path, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder(path.toFile(), wireType);
    }

    @NotNull
    public static SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        if (file.isFile()) {
            if (!file.getName().endsWith(".cq4")) {
                throw new IllegalArgumentException("Invalid file type: " + file.getName());
            }
            LOGGER.warn("Queues should be configured with the queue directory, not a specific filename. Actual file used: {}", (Object)file.getParentFile());
            return new SingleChronicleQueueBuilder(file.getParentFile()).wireType(wireType);
        }
        return new SingleChronicleQueueBuilder(file).wireType(wireType);
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull Path path) {
        return SingleChronicleQueueBuilder.binary(path.toFile());
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull String basePath) {
        return SingleChronicleQueueBuilder.binary(new File(basePath));
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.BINARY_LIGHT);
    }

    @NotNull
    public static SingleChronicleQueueBuilder fieldlessBinary(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.FIELDLESS_BINARY);
    }

    @NotNull
    public static SingleChronicleQueueBuilder defaultZeroBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DEFAULT_ZERO_BINARY);
    }

    @NotNull
    public static SingleChronicleQueueBuilder deltaBinary(@NotNull File basePathFile) {
        return SingleChronicleQueueBuilder.builder(basePathFile, WireType.DELTA_BINARY);
    }

    @Deprecated
    @NotNull
    public static SingleChronicleQueueBuilder text(@NotNull File name) {
        return SingleChronicleQueueBuilder.builder(name, WireType.TEXT);
    }

    @NotNull
    static SingleChronicleQueueStore createStore(@NotNull RollingChronicleQueue queue, @NotNull Wire wire) {
        SingleChronicleQueueStore wireStore = new SingleChronicleQueueStore(queue.rollCycle(), queue.wireType(), (MappedBytes)wire.bytes(), queue.indexCount(), queue.indexSpacing());
        wire.writeEventName(MetaDataKeys.header).typedMarshallable(wireStore);
        return wireStore;
    }

    @Nullable
    static SingleChronicleQueueStore loadStore(@NotNull Wire wire) {
        StringBuilder eventName = new StringBuilder();
        wire.readEventName(eventName);
        if (eventName.toString().equals(MetaDataKeys.header.name())) {
            SingleChronicleQueueStore store = (SingleChronicleQueueStore)wire.read().typedMarshallable();
            if (store == null) {
                throw new IllegalArgumentException("Unable to load wire store");
            }
            return store;
        }
        LOGGER.warn("Unable to load store file from input. Queue file may be corrupted.");
        return null;
    }

    private static boolean isQueueReplicationAvailable() {
        try {
            Class.forName("software.chronicle.enterprise.queue.QueueSyncReplicationHandler");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public SingleChronicleQueue build() {
        if (this.buffered()) {
            this.onlyAvailableInEnterprise("Buffering");
        }
        super.preBuild();
        return new SingleChronicleQueue(this);
    }

    private void onlyAvailableInEnterprise(String feature) {
        this.getLogger().warn(feature + " is only supported in Chronicle Queue Enterprise. If you would like to use this feature, please contact sales@chronicle.software for more information.");
    }

    @NotNull
    public SingleChronicleQueueBuilder<S> clone() {
        try {
            SingleChronicleQueueBuilder clone = (SingleChronicleQueueBuilder)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier() {
        return null;
    }

    @Nullable
    public Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier() {
        return null;
    }

    @NotNull
    public SingleChronicleQueueBuilder aesEncryption(@Nullable byte[] keyBytes) {
        if (keyBytes == null) {
            this.codingSuppliers(null, null);
            return this;
        }
        this.onlyAvailableInEnterprise("AES encryption");
        return this;
    }

    @NotNull
    public SingleChronicleQueueBuilder codingSuppliers(@Nullable Supplier<BiConsumer<BytesStore, Bytes>> encodingSupplier, @Nullable Supplier<BiConsumer<BytesStore, Bytes>> decodingSupplier) {
        if (encodingSupplier != null || decodingSupplier != null) {
            this.onlyAvailableInEnterprise("Custom encoding");
        }
        return this;
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> testBlockSize() {
        super.testBlockSize();
        return this;
    }

    @Override
    public SingleChronicleQueueBuilder<S> sourceId(int sourceId) {
        return (SingleChronicleQueueBuilder)super.sourceId(sourceId);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> blockSize(int blockSize) {
        return (SingleChronicleQueueBuilder)super.blockSize(blockSize);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> blockSize(long blockSize) {
        return (SingleChronicleQueueBuilder)super.blockSize(blockSize);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> wireType(@NotNull WireType wireType) {
        return (SingleChronicleQueueBuilder)super.wireType(wireType);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> rollCycle(@NotNull RollCycle rollCycle) {
        return (SingleChronicleQueueBuilder)super.rollCycle(rollCycle);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> bufferCapacity(long bufferCapacity) {
        return (SingleChronicleQueueBuilder)super.bufferCapacity(bufferCapacity);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> epoch(long epoch) {
        return (SingleChronicleQueueBuilder)super.epoch(epoch);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> buffered(boolean isBuffered) {
        return (SingleChronicleQueueBuilder)super.buffered(isBuffered);
    }

    @Override
    public SingleChronicleQueueBuilder<S> writeBufferMode(BufferMode writeBufferMode) {
        return (SingleChronicleQueueBuilder)super.writeBufferMode(writeBufferMode);
    }

    @Override
    public SingleChronicleQueueBuilder<S> readBufferMode(BufferMode readBufferMode) {
        return (SingleChronicleQueueBuilder)super.readBufferMode(readBufferMode);
    }

    @Override
    @NotNull
    public SingleChronicleQueueBuilder<S> eventLoop(EventLoop eventLoop) {
        return (SingleChronicleQueueBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public SingleChronicleQueueBuilder<S> indexCount(int indexCount) {
        return (SingleChronicleQueueBuilder)super.indexCount(indexCount);
    }

    @Override
    public SingleChronicleQueueBuilder<S> indexSpacing(int indexSpacing) {
        return (SingleChronicleQueueBuilder)super.indexSpacing(indexSpacing);
    }

    @Override
    public SingleChronicleQueueBuilder<S> timeProvider(TimeProvider timeProvider) {
        return (SingleChronicleQueueBuilder)super.timeProvider(timeProvider);
    }

    @Override
    public SingleChronicleQueueBuilder<S> pauserSupplier(Supplier<TimingPauser> pauser) {
        return (SingleChronicleQueueBuilder)super.pauserSupplier(pauser);
    }

    @Override
    public SingleChronicleQueueBuilder<S> timeoutMS(long timeoutMS) {
        return (SingleChronicleQueueBuilder)super.timeoutMS(timeoutMS);
    }

    @Override
    public SingleChronicleQueueBuilder<S> readOnly(boolean readOnly) {
        return (SingleChronicleQueueBuilder)super.readOnly(readOnly);
    }

    @Override
    public SingleChronicleQueueBuilder<S> storeFileListener(StoreFileListener storeFileListener) {
        return (SingleChronicleQueueBuilder)super.storeFileListener(storeFileListener);
    }

    @Override
    public SingleChronicleQueueBuilder<S> recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        return (SingleChronicleQueueBuilder)super.recoverySupplier(recoverySupplier);
    }

    @Override
    public SingleChronicleQueueBuilder<S> rollTime(@NotNull LocalTime time, ZoneId zoneId) {
        if (!zoneId.equals(ZoneId.of("UTC"))) {
            this.onlyAvailableInEnterprise("Non-UTC time-zone");
        }
        return (SingleChronicleQueueBuilder)super.rollTime(time, ZoneId.of("UTC"));
    }

    @Override
    protected void initializeMetadata() {
        File metapath = this.metapath();
        this.validateRollCycle(metapath);
        SCQMeta metadata = new SCQMeta(new SCQRoll(this.rollCycle, this.epoch), this.deltaCheckpointInterval(), this.sourceId());
        try {
            this.metaStore = SingleTableBuilder.binary(metapath, metadata).timeoutMS(this.timeoutMS()).readOnly(this.readOnly()).validateMetadata(!this.readOnly).build();
            SCQMeta newMeta = this.metaStore.metadata();
            if (this.sourceId() == 0) {
                this.sourceId(newMeta.sourceId());
            }
            if (this.readOnly && !newMeta.roll().format().equals(this.rollCycle.format())) {
                this.overrideRollCycleForFileNameLength(newMeta.roll().format().length());
            }
        }
        catch (IORuntimeException ex) {
            this.metaStore = new ReadonlyTableStore<SCQMeta>(metadata);
        }
    }

    private void validateRollCycle(File metapath) {
        String[] list;
        if (!metapath.exists() && (list = this.path.list((d, name) -> name.endsWith(".cq4"))) != null && list.length > 0) {
            String filename = list[0];
            if (this.rollCycle.format().length() + 4 != filename.length()) {
                this.overrideRollCycleForFileNameLength(filename.length() - 4);
            }
        }
    }

    private void overrideRollCycleForFileNameLength(int patternLength) {
        for (RollCycles cycle : RollCycles.values()) {
            if (cycle.format().length() != patternLength) continue;
            LOGGER.warn("Overriding roll cycle to " + cycle);
            this.rollCycle = cycle;
            break;
        }
    }

    private File metapath() {
        File storeFilePath;
        if ("".equals(this.path.getPath())) {
            storeFilePath = new File("metadata.cq4t");
        } else {
            storeFilePath = new File(this.path, "metadata.cq4t");
            this.path.mkdirs();
        }
        return storeFilePath;
    }

    @NotNull
    protected QueueLock queueLock() {
        return SingleChronicleQueueBuilder.isQueueReplicationAvailable() && !this.readOnly() ? new TSQueueLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L) : new NoopQueueLock();
    }

    @NotNull
    protected WriteLock writeLock() {
        return this.readOnly() ? new ReadOnlyWriteLock() : new TableStoreWriteLock(this.metaStore, this.pauserSupplier(), this.timeoutMS() * 3L / 2L);
    }

    protected int deltaCheckpointInterval() {
        return -1;
    }

    protected TableStore<SCQMeta> metaStore() {
        return this.metaStore;
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(WireType.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQMeta.class, "SCQMeta");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "SCQSRoll");
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class, "SCQSIndexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "SCQStore");
        ClassAliasPool.CLASS_ALIASES.addAlias(TimedStoreRecovery.class);
    }
}

