/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingOutputStream;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.Histogram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataOutput<S extends StreamingDataOutput<S>>
extends StreamingCommon<S> {
    public static final int JAVA9_STRING_CODER_LATIN = 0;
    public static final int JAVA9_STRING_CODER_UTF16 = 1;

    @NotNull
    public S writePosition(long var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeLimit(long var1) throws BufferOverflowException;

    @NotNull
    public S writeSkip(long var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public OutputStream outputStream() {
        return new StreamingOutputStream(this);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeStopBit(long x) throws BufferOverflowException {
        BytesInternal.writeStopBit(this, x);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeStopBit(char x) throws BufferOverflowException {
        BytesInternal.writeStopBit(this, x);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeStopBit(double d) throws BufferOverflowException {
        BytesInternal.writeStopBit(this, d);
        return (S)this;
    }

    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeStopBitDecimal(double d) throws BufferOverflowException {
        long value;
        boolean negative = d < 0.0;
        double ad = Math.abs(d);
        if ((double)((long)ad) == ad) {
            value = (long)ad * 10L;
        } else {
            double v;
            int scale;
            double factor = 1.0;
            for (scale = 0; scale < 9 && !((v = ad * factor) >= 1.0E14) && (double)((long)v) != v; ++scale) {
                factor *= 10.0;
            }
            value = Math.round(ad * factor);
            while (scale > 0 && value % 10L == 0L) {
                value /= 10L;
                --scale;
            }
            value = value * 10L + (long)scale;
        }
        if (negative) {
            value = -value;
        }
        BytesInternal.writeStopBit(this, value);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUtf8(CharSequence cs) throws BufferOverflowException {
        BytesInternal.writeUtf8(this, cs);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUtf8(String s) throws BufferOverflowException {
        BytesInternal.writeUtf8(this, s);
        return (S)this;
    }

    @Deprecated
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUTF\u0394(CharSequence cs) throws BufferOverflowException {
        return this.writeUtf8(cs);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@Nullable CharSequence cs) throws BufferOverflowException {
        if (cs == null) {
            return this.writeStopBit(-1L);
        }
        if (cs instanceof BytesStore) {
            return this.write8bit((BytesStore)cs);
        }
        if (cs instanceof String) {
            return this.write8bit((String)cs);
        }
        return this.write8bit(cs, 0, cs.length());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence s, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException {
        this.writeStopBit(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i + start);
            this.writeUnsignedByte(c);
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException {
        if (cs instanceof BytesStore) {
            return this.write((BytesStore)cs);
        }
        return this.write(cs, 0, cs.length());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence s, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException {
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i + start);
            this.appendUtf8(c);
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@Nullable String s) throws BufferOverflowException {
        if (s == null) {
            this.writeStopBit(-1L);
        } else {
            this.write8bit(s, 0, (int)Math.min(this.writeRemaining(), (long)s.length()));
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@Nullable BytesStore bs) throws BufferOverflowException {
        if (bs == null) {
            this.writeStopBit(-1L);
        } else {
            long offset = bs.readPosition();
            long readRemaining = Math.min(this.writeRemaining(), bs.readLimit() - offset);
            this.writeStopBit(readRemaining);
            this.write(bs, offset, readRemaining);
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeByte(byte var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedByte(int i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeByte((byte)Maths.toUInt8(i));
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeShort(short var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedShort(int u16) throws BufferOverflowException, IllegalArgumentException {
        return this.writeShort((short)Maths.toUInt16(u16));
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeInt24(int i) throws BufferOverflowException {
        this.writeUnsignedShort((short)i);
        return this.writeUnsignedByte(i >>> 16 & 0xFF);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedInt24(int i) throws BufferOverflowException {
        this.writeUnsignedShort((short)i);
        return this.writeUnsignedByte(i >>> 16);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeInt(int var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeIntAdv(int var1, int var2) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedInt(long i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeInt((int)Maths.toUInt32(i));
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeLong(long var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeLongAdv(long var1, int var3) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeFloat(float var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeDouble(double var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeDoubleAndInt(double var1, int var3) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull BytesStore bytes) {
        if (!1.$assertionsDisabled && bytes == this) {
            throw new AssertionError((Object)"you should not write to yourself !");
        }
        try {
            return this.write(bytes, bytes.readPosition(), Math.min(this.writeRemaining(), bytes.readRemaining()));
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long realCapacity();

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeSome(@NotNull @net.openhft.chronicle.core.annotation.NotNull Bytes bytes) {
        try {
            long length = Math.min(bytes.readRemaining(), this.writeRemaining());
            if (length + this.writePosition() >= 0x100000L) {
                length = Math.min(bytes.readRemaining(), this.realCapacity() - this.writePosition());
            }
            this.write(bytes, bytes.readPosition(), length);
            if (length == bytes.readRemaining()) {
                bytes.clear();
            } else {
                bytes.readSkip(length);
                if (bytes.writePosition() > bytes.realCapacity() / 2L) {
                    bytes.compact();
                }
            }
            return (S)this;
        }
        catch (IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        BytesInternal.writeFully(bytes, offset, length, this);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull byte[] bytes) throws BufferOverflowException {
        this.write(bytes, 0, bytes.length);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S write(byte[] var1, int var2, int var3) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeSome(ByteBuffer var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeBoolean(boolean flag) throws BufferOverflowException {
        return this.writeByte(flag ? (byte)89 : 78);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeOrderedInt(int var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeOrderedLong(long var1) throws BufferOverflowException;

    @Deprecated
    public void nativeWrite(long var1, long var3) throws BufferOverflowException;

    default public <E extends Enum<E>> void writeEnum(@NotNull @net.openhft.chronicle.core.annotation.NotNull E e) throws BufferOverflowException {
        this.write8bit(e.name());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S appendUtf8(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence cs) throws BufferOverflowException {
        return this.appendUtf8(cs, 0, cs.length());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S appendUtf8(int codepoint) throws BufferOverflowException {
        BytesInternal.appendUtf8Char(this, codepoint);
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        char c;
        int i;
        block3: {
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    this.writeByte((byte)c);
                    continue;
                }
                break block3;
            }
            return (S)this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S appendUtf8(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence cs, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        BytesInternal.appendUtf8(this, cs, offset, length);
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(byte[] bytes, int offset, int length, byte coder) throws BufferOverflowException, IllegalArgumentException {
        if (coder == 0) {
            for (int i = 0; i < length; ++i) {
                byte b = bytes[offset + i];
                int b2 = b & 0xFF;
                BytesInternal.appendUtf8Char(this, b2);
            }
        } else {
            if (!1.$assertionsDisabled && coder != 1) {
                throw new AssertionError();
            }
            for (int i = 0; i < 2 * length; i += 2) {
                byte b1 = bytes[2 * offset + i];
                byte b2 = bytes[2 * offset + i + 1];
                int uBE = (b2 & 0xFF) << 8 | b1 & 0xFF;
                BytesInternal.appendUtf8Char(this, uBE);
            }
        }
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        for (int i = 0; i < length; ++i) {
            int b3;
            int b2;
            int b = bytes[offset + i] & 0xFF;
            if (b >= 240) {
                b2 = bytes[offset + i + 1] & 0xFF;
                b3 = bytes[offset + i + 2] & 0xFF;
                int b4 = bytes[offset + i + 3] & 0xFF;
                this.writeByte((byte)b4);
                this.writeByte((byte)b3);
                this.writeByte((byte)b2);
                this.writeByte((byte)b);
                i += 3;
                continue;
            }
            if (b >= 224) {
                b2 = bytes[offset + i + 1] & 0xFF;
                b3 = bytes[offset + i + 2] & 0xFF;
                this.writeByte((byte)b3);
                this.writeByte((byte)b2);
                this.writeByte((byte)b);
                i += 2;
                continue;
            }
            if (b >= 192) {
                b2 = bytes[offset + i + 1] & 0xFF;
                this.writeByte((byte)b2);
                this.writeByte((byte)b);
                ++i;
                continue;
            }
            this.writeByte((byte)b);
        }
        return (S)this;
    }

    default public void copyFrom(@NotNull @net.openhft.chronicle.core.annotation.NotNull InputStream input) throws IOException, BufferOverflowException, IllegalArgumentException {
        BytesInternal.copy(input, this);
    }

    default public void writePositionRemaining(long position, long length) {
        this.writeLimit(position + length);
        this.writePosition(position);
    }

    default public void writeHistogram(@NotNull @net.openhft.chronicle.core.annotation.NotNull Histogram histogram) {
        BytesInternal.writeHistogram(this, histogram);
    }

    default public void writeBigDecimal(@NotNull @net.openhft.chronicle.core.annotation.NotNull BigDecimal bd) {
        this.writeBigInteger(bd.unscaledValue());
        this.writeStopBit(bd.scale());
    }

    default public void writeBigInteger(@NotNull @net.openhft.chronicle.core.annotation.NotNull BigInteger bi) {
        byte[] bytes = bi.toByteArray();
        this.writeStopBit(bytes.length);
        this.write(bytes);
    }

    default public void writeWithLength(BytesStore bytes) {
        this.writeStopBit(bytes.readRemaining());
        this.write(bytes);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

