/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.ReferenceTracker;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ReferenceTrackerTest {
    @Rule
    public final TemporaryFolder tmpDir = new TemporaryFolder();
    private final ReferenceTracker.ReverseCharSequenceIntegerEncoder encoder = new ReferenceTracker.ReverseCharSequenceIntegerEncoder();
    private TableStore tableStore;
    private ReferenceTracker tracker;

    private static String sequenceToString(CharSequence sequence) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < sequence.length(); ++i) {
            buffer.append(sequence.charAt(i));
        }
        return buffer.toString();
    }

    @Before
    public void setUp() throws Exception {
        this.tableStore = SingleTableBuilder.binary((File)this.tmpDir.newFile("table-store.cq4t")).build();
        this.tracker = new ReferenceTracker(this.tableStore);
    }

    @Test
    public void shouldTrackReferencesCycles() throws IOException {
        this.tracker.acquired(17);
        this.tracker.acquired(17);
        this.assertReferenceCount(17, 2L);
        this.tracker.acquired(17);
        this.assertReferenceCount(17, 3L);
        this.tracker.released(17);
        this.tracker.released(17);
        this.assertReferenceCount(17, 1L);
    }

    @Test
    public void shouldEncodeInteger() {
        for (int i = 0; i < 1000; ++i) {
            this.assertEncoding(ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE));
        }
    }

    @Test
    public void shouldEncodeZero() {
        this.assertEncoding(0);
    }

    private void assertEncoding(int value) {
        this.encoder.encode(value);
        Assert.assertThat((Object)ReferenceTrackerTest.sequenceToString((CharSequence)this.encoder), (Matcher)CoreMatchers.is((Object)Integer.toString(value)));
    }

    private void assertReferenceCount(int cycle, long expectedCount) {
        Assert.assertThat((Object)this.tableStore.acquireValueFor((CharSequence)Integer.toString(cycle)).getVolatileValue(), (Matcher)CoreMatchers.is((Object)expectedCount));
    }
}

