/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.FileNotFoundException;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;

public class MultiQueueStressMain {
    static final int queueCount = Integer.getInteger("queues", 25);
    static final int throughput = Integer.getInteger("throughput", 50);
    static final String target = System.getProperty("target", OS.TARGET);
    static final int runs = Integer.getInteger("runs", 10);

    public static void main(String[] args) throws FileNotFoundException {
        for (int t = 0; t < runs; ++t) {
            long start0 = System.currentTimeMillis();
            int count = 0;
            String baseDir = target + "/deleteme/" + System.nanoTime();
            new File(baseDir).mkdirs();
            MappedBytes[] queues = new MappedBytes[queueCount];
            int pagesPer10Second = (int)(10L * (long)(throughput << 20) / (long)queueCount / 4096L);
            for (int i = 0; i < queueCount; ++i) {
                long start1 = System.currentTimeMillis();
                String filename = baseDir + "/" + count++;
                queues[i] = MappedBytes.mappedBytes((String)filename, (long)(pagesPer10Second * 4096));
                long time1 = System.currentTimeMillis() - start1;
                if (time1 <= 20L) continue;
                System.out.printf("Creating %s took %.3f seconds%n", filename, (double)time1 / 1000.0);
            }
            long mid1 = System.currentTimeMillis();
            for (int i = 0; i < pagesPer10Second; ++i) {
                for (MappedBytes bytes : queues) {
                    bytes.writeLong((long)(i * 4096), (long)i);
                }
            }
            long mid2 = System.currentTimeMillis();
            for (MappedBytes bytes : queues) {
                bytes.release();
            }
            long end0 = System.currentTimeMillis();
            long time0 = end0 - start0;
            System.out.printf("Took %.3f seconds to write %,d MB, create: %.3f, write: %.3f, close: %.3f%n", (double)time0 / 1000.0, throughput * 10, (double)(mid1 - start0) / 1000.0, (double)(mid2 - mid1) / 1000.0, (double)(end0 - mid2) / 1000.0);
            long delay = 10000L - time0;
            if (delay <= 0L) continue;
            Jvm.pause((long)delay);
        }
    }
}

