/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.reader.ChronicleReader;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.junit.Assert;
import org.junit.Test;

public class RollEOFTest {
    private final File path = DirectoryUtils.tempDir(this.getClass().getName());

    @Test(timeout=5000L)
    public void testRollWritesEOF() throws Exception {
        SetTimeProvider timeProvider = new SetTimeProvider();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        timeProvider.currentTimeMillis(cal.getTimeInMillis());
        this.createQueueAndWriteData((TimeProvider)timeProvider);
        Assert.assertEquals((long)1L, (long)this.getNumberOfQueueFiles());
        timeProvider.currentTimeMillis(System.currentTimeMillis());
        this.createQueueAndWriteData((TimeProvider)timeProvider);
        Assert.assertEquals((long)2L, (long)this.getNumberOfQueueFiles());
        LinkedList l = new LinkedList();
        new ChronicleReader().withMessageSink(l::add).withBasePath(this.path.toPath()).execute();
        Assert.assertEquals((long)4L, (long)l.size());
    }

    @Test(timeout=5000L)
    public void testRollWithoutEOFDoesntBlowup() throws Exception {
        SetTimeProvider timeProvider = new SetTimeProvider();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        timeProvider.currentTimeMillis(cal.getTimeInMillis());
        this.createQueueAndWriteData((TimeProvider)timeProvider);
        Assert.assertEquals((long)1L, (long)this.getNumberOfQueueFiles());
        timeProvider.currentTimeMillis(System.currentTimeMillis());
        this.createQueueAndWriteData((TimeProvider)timeProvider);
        Assert.assertEquals((long)2L, (long)this.getNumberOfQueueFiles());
        Optional<Path> firstQueueFile = Files.list(this.path.toPath()).filter(p -> p.toString().endsWith(".cq4")).sorted().findFirst();
        Assert.assertTrue((boolean)firstQueueFile.isPresent());
        this.removeEOF(firstQueueFile.get());
        LinkedList l = new LinkedList();
        new ChronicleReader().withMessageSink(l::add).withBasePath(this.path.toPath()).execute();
        Assert.assertEquals((long)4L, (long)l.size());
    }

    @Test(timeout=5000L)
    public void testRollWithoutEOF() throws Exception {
        SetTimeProvider timeProvider = new SetTimeProvider();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -3);
        timeProvider.currentTimeMillis(cal.getTimeInMillis());
        this.createQueueAndWriteData((TimeProvider)timeProvider);
        Assert.assertEquals((long)1L, (long)this.getNumberOfQueueFiles());
        timeProvider.currentTimeMillis(System.currentTimeMillis());
        this.createQueueAndWriteData((TimeProvider)timeProvider);
        Assert.assertEquals((long)2L, (long)this.getNumberOfQueueFiles());
        Optional<Path> firstQueueFile = Files.list(this.path.toPath()).filter(p -> p.toString().endsWith(".cq4")).sorted().findFirst();
        Assert.assertTrue((boolean)firstQueueFile.isPresent());
        this.removeEOF(firstQueueFile.get());
        LinkedList l = new LinkedList();
        new ChronicleReader().withMessageSink(l::add).withBasePath(this.path.toPath()).withReadOnly(false).execute();
        Assert.assertEquals((long)4L, (long)l.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEOF(Path path) throws IOException {
        long blockSize = 65536L;
        long chunkSize = OS.pageAlign((long)blockSize);
        long overlapSize = OS.pageAlign((long)(blockSize / 4L));
        MappedBytes mappedBytes = MappedBytes.mappedBytes((File)path.toFile(), (long)chunkSize, (long)overlapSize, (boolean)false);
        mappedBytes.reserve();
        try {
            Wire wire = (Wire)WireType.BINARY_LIGHT.apply((Object)mappedBytes);
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            bytes.readSkip(4L);
            try (SingleChronicleQueueStore qs = this.loadStore(wire);){
                Assert.assertNotNull((Object)qs);
                long l = qs.writePosition();
                long len = Wires.lengthOf((int)bytes.readVolatileInt(l));
                long eofOffset = l + len + 4L;
                bytes.writePosition(eofOffset);
                bytes.writeInt(0);
            }
        }
        finally {
            mappedBytes.release();
        }
    }

    private SingleChronicleQueueStore loadStore(Wire wire) {
        try {
            Method loadStoreMethod = SingleChronicleQueueBuilder.class.getDeclaredMethod("loadStore", Wire.class);
            loadStoreMethod.setAccessible(true);
            return (SingleChronicleQueueStore)loadStoreMethod.invoke(null, wire);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private long getNumberOfQueueFiles() throws IOException {
        return this.getQueueFilesStream().count();
    }

    private Stream<Path> getQueueFilesStream() throws IOException {
        return Files.list(this.path.toPath()).filter(p -> p.toString().endsWith(".cq4"));
    }

    private void createQueueAndWriteData(TimeProvider timeProvider) {
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeProvider(timeProvider).build();
        ExcerptAppender excerptAppender = queue.acquireAppender();
        try (DocumentContext dc = excerptAppender.writingDocument(false);){
            dc.wire().write(() -> "test").int64(0L);
        }
    }
}

