/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.jitter;

import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;

public class QueuePingPongMain {
    static int runtime = Integer.getInteger("runtime", 30);
    static String basePath = System.getProperty("path", OS.TMP);
    static volatile long writeTime = 0L;
    static volatile int writeCount = 0;
    static volatile int readCount = 0;
    static volatile boolean running = true;

    public static void main(String[] args) {
        System.out.println(" -Druntime=" + runtime + " -Dpath=" + basePath);
        MappedFile.warmup();
        QueuePingPongMain.pingPong(64);
    }

    static void pingPong(int size) {
        String path = basePath + "/test-q-" + System.nanoTime();
        Histogram readDelay = new Histogram();
        Histogram readDelay2 = new Histogram();
        try (SingleChronicleQueue queue = QueuePingPongMain.createQueue(path);){
            Thread reader = new Thread(() -> {
                ExcerptTailer tailer = queue.createTailer();
                while (running) {
                    while (readCount == writeCount) {
                    }
                    long wakeTime = System.nanoTime();
                    while (running) {
                        int count = 0;
                        DocumentContext dc = tailer.readingDocument(true);
                        Throwable throwable = null;
                        try {
                            if (!dc.isPresent()) {
                                ++count;
                                continue;
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (dc == null) continue;
                            if (throwable != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            dc.close();
                            continue;
                        }
                        if (count <= 0) break;
                        System.out.println(count);
                        break;
                    }
                    long delay = wakeTime - writeTime;
                    long time = System.nanoTime() - wakeTime;
                    readDelay2.sample(time);
                    readDelay.sample(delay);
                    if (time + delay > 20000L) {
                        System.out.println("td " + delay + " + " + time);
                    }
                    if (readCount == 100000) {
                        System.out.println("reset");
                        readDelay.reset();
                        readDelay2.reset();
                    }
                    ++readCount;
                }
            });
            reader.setDaemon(true);
            reader.start();
            Jvm.pause(100L);
            long finish = System.currentTimeMillis() + (long)(runtime * 1000);
            ExcerptAppender appender = queue.acquireAppender();
            while (System.currentTimeMillis() < finish) {
                if (readCount < writeCount) {
                    Thread.yield();
                    continue;
                }
                try (DocumentContext dc = appender.writingDocument(false);){
                    dc.wire().bytes().writeSkip(size);
                }
                ++writeCount;
                writeTime = System.nanoTime();
            }
            running = false;
        }
        System.out.println("read delay: " + readDelay.toMicrosFormat());
        System.out.println("read delay2: " + readDelay2.toMicrosFormat());
        IOTools.deleteDirWithFiles(path, 2);
    }

    @NotNull
    private static SingleChronicleQueue createQueue(String path) {
        return ChronicleQueueBuilder.single(path).build();
    }

    static {
        System.setProperty("jvm.safepoint.enabled", "true");
    }
}

