/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.DumpQueueMain;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class StuckQueueTest {
    Path tmpDir = DirectoryUtils.tempDir(StuckQueueTest.class.getSimpleName()).toPath();

    @Before
    public void setup() throws Exception {
        this.tmpDir.toFile().mkdirs();
    }

    @After
    public void cleanup() {
        DirectoryUtils.deleteDir(this.tmpDir.toFile());
    }

    @Test
    public void test() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        Path templatePath = Paths.get(StuckQueueTest.class.getResource("/stuck.queue.test/20180508-1249.cq4").getFile(), new String[0]);
        Path to = this.tmpDir.resolve(templatePath.getFileName());
        Files.copy(templatePath, to, StandardCopyOption.REPLACE_EXISTING);
        DumpQueueMain.dump((String)this.tmpDir.toString());
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((Path)this.tmpDir).rollCycle((RollCycle)RollCycles.MINUTELY).readOnly(true).build();){
            ExcerptTailer tailer = q.createTailer();
            int cycle = q.rollCycle().toCycle(109219854401142784L);
            WireStore wireStore = q.storeForCycle(cycle, q.epoch(), false);
            String absolutePath = wireStore.file().getAbsolutePath();
            System.out.println(absolutePath);
            Assert.assertTrue((boolean)absolutePath.endsWith("20180508-1249.cq4"));
            try (DocumentContext dc = tailer.readingDocument();){
                System.out.println(Long.toHexString(dc.index()));
            }
            dc = SingleChronicleQueueBuilder.binary((Path)this.tmpDir).rollCycle((RollCycle)RollCycles.MINUTELY).build().acquireAppender().writingDocument();
            var10_12 = null;
            try {
                dc.wire().write((CharSequence)"hello").text("world");
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var10_12 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                String actual = dc.wire().read("hello").text();
                Assert.assertEquals((Object)"world", (Object)actual);
                System.out.println(Long.toHexString(dc.index()));
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }
}

