/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import junit.framework.TestCase;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireDumper;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FsFullReadTest {
    @NotNull
    private static String basePath = "src/test/resources/tr2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="broken test")
    @Test
    public void testFullReadFs() throws Exception {
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)basePath).blockSize(65536).rollCycle((RollCycle)RollCycles.DAILY).build();
        ExcerptTailer tailer = queue.createTailer();
        DocumentContext dc = tailer.readingDocument();
        boolean doExit = false;
        int entries = 0;
        while (!doExit) {
            try {
                if (dc.isPresent()) {
                    ++entries;
                    Wire w = dc.wire();
                    LocalDateTime dt = w.read().dateTime();
                    TestCase.assertNotNull((Object)dt);
                    byte[] b = w.read().bytes();
                    Assert.assertEquals((long)1024L, (long)b.length);
                    continue;
                }
                System.out.println("Exiting");
                doExit = true;
            }
            finally {
                dc.close();
            }
        }
        System.out.println(String.format("Read %d entries.", entries));
        WireStore commonStore = queue.storeForCycle(queue.cycle(), 0L, false);
        File file = commonStore.file();
        queue.close();
        int dumpEntries = 0;
        try {
            MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)0x400000L);
            bytes.readLimit(bytes.realCapacity());
            WireDumper dumper = WireDumper.of((Bytes)bytes);
            Bytes buffer = Bytes.elasticByteBuffer();
            while (bytes.readRemaining() >= 4L) {
                StringBuilder sb = new StringBuilder();
                boolean last = dumper.dumpOne(sb, buffer);
                Assert.assertTrue((sb.length() > 0 ? 1 : 0) != 0);
                if (!last) {
                    ++dumpEntries;
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            System.err.println("Failed to read " + file + " " + ioe);
        }
        Assert.assertEquals((long)dumpEntries, (long)entries);
    }
}

