/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class WriteBytesTest {
    private static final byte[] PAYLOAD = new byte[]{126, 66, 25, 55};
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @Test
    public void shouldWriteBytes() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmpDir.newFolder()).testBlockSize().build();){
            ExcerptAppender appender = queue.acquireAppender();
            HeapBytesStore store = HeapBytesStore.uninitialized();
            store.init(ByteBuffer.wrap(PAYLOAD));
            appender.writeBytes((BytesStore)store);
            ExcerptTailer tailer = queue.createTailer();
            HeapBytesStore copy = HeapBytesStore.uninitialized();
            copy.init(new byte[4]);
            tailer.readBytes(copy.bytesForWrite());
            Assert.assertTrue((boolean)Arrays.equals(PAYLOAD, (byte[])copy.underlyingObject()));
        }
    }
}

