/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.AbstractBytesMarshallable;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class DtoBytesMarshallableTest {
    @Test
    public void testDtoBytesMarshallable() {
        File tmp = DirectoryUtils.tempDir("abstractBytesMarshalTest");
        DtoBytesMarshallable dto = new DtoBytesMarshallable();
        dto.age = 45;
        dto.name.append("rob");
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)tmp).build();){
            try (DocumentContext dc = q.acquireAppender().writingDocument();){
                dc.wire().write((CharSequence)"who").object((Object)dto);
            }
            dc = q.createTailer().readingDocument();
            var6_8 = null;
            try {
                DtoBytesMarshallable who = (DtoBytesMarshallable)((Object)dc.wire().read("who").object());
                Assert.assertEquals((Object)"!net.openhft.chronicle.queue.DtoBytesMarshallableTest$DtoBytesMarshallable {\n  name: rob,\n  age: 45\n}\n", (Object)who.toString());
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_8 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDtoAbstractMarshallable() {
        File tmp = DirectoryUtils.tempDir("abstractBytesMarshalTest");
        DtoAbstractMarshallable dto = new DtoAbstractMarshallable();
        dto.age = 45;
        dto.name.append("rob");
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)tmp).build();){
            try (DocumentContext dc = q.acquireAppender().writingDocument();){
                dc.wire().write((CharSequence)"who").object((Object)dto);
            }
            dc = q.createTailer().readingDocument();
            var6_8 = null;
            try {
                String yaml = dc.toString();
                System.out.println(yaml);
                DtoAbstractMarshallable who = (DtoAbstractMarshallable)((Object)dc.wire().read("who").object());
                System.out.println((Object)who);
                Assert.assertTrue((boolean)yaml.contains(who.toString()));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var6_8 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    public static class DtoAbstractMarshallable
    extends AbstractMarshallable {
        StringBuilder name = new StringBuilder();
        int age;

        public void readMarshallable(BytesIn bytes) {
            this.age = bytes.readInt();
            this.name.setLength(0);
            bytes.readUtf8((Appendable)this.name);
        }

        public void writeMarshallable(BytesOut bytes) {
            bytes.writeInt(this.age);
            bytes.writeUtf8((CharSequence)this.name);
        }
    }

    public static class DtoBytesMarshallable
    extends AbstractBytesMarshallable {
        StringBuilder name = new StringBuilder();
        int age;

        public void readMarshallable(BytesIn bytes) {
            this.age = bytes.readInt();
            this.name.setLength(0);
            bytes.readUtf8((Appendable)this.name);
        }

        public void writeMarshallable(BytesOut bytes) {
            bytes.writeInt(this.age);
            bytes.writeUtf8((CharSequence)this.name);
        }
    }
}

