/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CreateAtIndexTest {
    public static final Bytes<byte[]> HELLO_WORLD = Bytes.from((CharSequence)"hello world");

    @Test
    public void testWriteBytesWithIndex() throws Exception {
        SingleChronicleQueueExcerpts.InternalAppender appender3;
        Throwable throwable;
        SingleChronicleQueue queue;
        SingleChronicleQueueExcerpts.InternalAppender appender2;
        String tmp = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        try (SingleChronicleQueue queue2 = ChronicleQueueBuilder.single((String)tmp).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            appender2 = (SingleChronicleQueueExcerpts.InternalAppender)queue2.acquireAppender();
            appender2.writeBytes(72692321484800L, HELLO_WORLD);
            appender2.writeBytes(72692321484801L, HELLO_WORLD);
        }
        queue2 = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
        var3_4 = null;
        try {
            appender2 = (SingleChronicleQueueExcerpts.InternalAppender)queue2.acquireAppender();
            String before = queue2.dump();
            appender2.writeBytes(72692321484800L, HELLO_WORLD);
            String after = queue2.dump();
            Assert.assertEquals((Object)before, (Object)after);
        }
        catch (Throwable throwable2) {
            var3_4 = throwable2;
            throw throwable2;
        }
        finally {
            if (queue2 != null) {
                if (var3_4 != null) {
                    try {
                        queue2.close();
                    }
                    catch (Throwable throwable3) {
                        var3_4.addSuppressed(throwable3);
                    }
                } else {
                    queue2.close();
                }
            }
        }
        boolean runIfAssertsOn = false;
        if (runIfAssertsOn) {
            queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
            throwable = null;
            try {
                appender3 = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
                String before = queue.dump();
                try {
                    appender3.writeBytes(72692321484800L, (BytesStore)Bytes.from((CharSequence)"hellooooo world"));
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                String after = queue.dump();
                Assert.assertEquals((Object)before, (Object)after);
            }
            catch (Throwable appender3) {
                throwable = appender3;
                throw appender3;
            }
            finally {
                if (queue != null) {
                    if (throwable != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable appender3) {
                            throwable.addSuppressed(appender3);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
        throwable = null;
        try {
            appender3 = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
            try {
                appender3.writeBytes(72692321484803L, HELLO_WORLD);
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)"Unable to move to index 421d00000003 beyond the end of the queue", (Object)e.getMessage());
            }
        }
        catch (Throwable appender4) {
            throwable = appender4;
            throw appender4;
        }
        finally {
            if (queue != null) {
                if (throwable != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender4) {
                        throwable.addSuppressed(appender4);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();
        throwable = null;
        try {
            appender3 = (SingleChronicleQueueExcerpts.InternalAppender)queue.acquireAppender();
            appender3.writeBytes(72692321484802L, HELLO_WORLD);
            appender3.writeBytes(72692321484803L, HELLO_WORLD);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (queue != null) {
                if (throwable != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    queue.close();
                }
            }
        }
        try {
            IOTools.deleteDirWithFiles((String)tmp, (int)2);
        }
        catch (IORuntimeException iORuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWrittenAndReadIndexesAreTheSameOfTheFirstExcerpt() throws Exception {
        String tmp = OS.TARGET + "/" + this.getClass().getSimpleName() + "-" + System.nanoTime();
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((String)tmp).testBlockSize().build();){
            long expected;
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("some-data");
                expected = dc.index();
                Assert.assertTrue((expected > 0L ? 1 : 0) != 0);
            }
            appender.lastIndexAppended();
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                String text = dc.wire().read().text();
                long actualIndex = dc.index();
                Assert.assertTrue((actualIndex > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)expected, (long)actualIndex);
                actualIndex = tailer.index();
                Assert.assertTrue((actualIndex > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)expected, (long)actualIndex);
            }
        }
    }

    @After
    public void checkRegisteredBytes() {
        BytesUtil.checkRegisteredBytes();
    }
}

