/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.wire.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StoreComponentReferenceHandler implements Closeable
{
    INSTANCE;

    public static final String THREAD_NAME = "queue-thread-local-cleaner-daemon";
    private static final Logger LOGGER;
    private static final ReferenceQueue<ExcerptAppender> EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE;
    private static final ReferenceQueue<SingleChronicleQueueExcerpts.StoreTailer> EXPIRED_THREAD_LOCAL_TAILERS_QUEUE;
    private static final ExecutorService THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE;
    private static final Queue<Wire> WIRES_TO_RELEASE;
    private static final ConcurrentMap<Reference<?>, Runnable> CLOSE_ACTIONS;
    private static final boolean SHOULD_RELEASE_RESOURCES;
    private static final int MAX_BATCH_SIZE;
    private static final AtomicBoolean MAX_BATCH_WARNING_LOGGED;

    static ReferenceQueue<ExcerptAppender> appenderQueue() {
        return EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE;
    }

    static ReferenceQueue<SingleChronicleQueueExcerpts.StoreTailer> tailerQueue() {
        return EXPIRED_THREAD_LOCAL_TAILERS_QUEUE;
    }

    static <T> void register(Reference<T> reference, Runnable cleanupJob) {
        CLOSE_ACTIONS.put(reference, cleanupJob);
    }

    static void queueForRelease(Wire wire) {
        WIRES_TO_RELEASE.add(wire);
    }

    private static boolean processWireQueue() {
        Wire wireToRelease;
        boolean released = false;
        while ((wireToRelease = WIRES_TO_RELEASE.poll()) != null) {
            try {
                released = true;
                wireToRelease.bytes().release();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to release wire bytes", t);
            }
        }
        return released;
    }

    private static boolean processReferenceQueue(ReferenceQueue<?> referenceQueue) {
        int processedCount = 0;
        try {
            Reference<?> reference;
            while ((reference = referenceQueue.poll()) != null) {
                Runnable closeAction;
                if (processedCount++ == MAX_BATCH_SIZE) {
                    if (!MAX_BATCH_WARNING_LOGGED.get()) {
                        MAX_BATCH_WARNING_LOGGED.set(true);
                        LOGGER.warn("Weak ref queue processed {} entries, consider increasing max batch size via -Dchronicle.queue.release.weakRef.maxBatch", (Object)MAX_BATCH_SIZE);
                    }
                    return true;
                }
                if (reference.get() != null || (closeAction = (Runnable)CLOSE_ACTIONS.remove(reference)) == null || !SHOULD_RELEASE_RESOURCES) continue;
                closeAction.run();
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error occurred attempting to close ExcerptAppender.", e);
        }
        return processedCount != 0;
    }

    @Override
    public void close() {
        THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE.shutdownNow();
        try {
            THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(StoreComponentReferenceHandler.class);
        EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE = new ReferenceQueue();
        EXPIRED_THREAD_LOCAL_TAILERS_QUEUE = new ReferenceQueue();
        THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE = Threads.acquireExecutorService(THREAD_NAME, 1, true);
        WIRES_TO_RELEASE = new ConcurrentLinkedQueue<Wire>();
        CLOSE_ACTIONS = new ConcurrentHashMap();
        SHOULD_RELEASE_RESOURCES = Boolean.valueOf(System.getProperty("chronicle.queue.release.weakRef.resources", Boolean.TRUE.toString()));
        MAX_BATCH_SIZE = Integer.getInteger("chronicle.queue.release.weakRef.maxBatch", 10000);
        MAX_BATCH_WARNING_LOGGED = new AtomicBoolean(false);
        THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE.submit(() -> {
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                boolean workDone = StoreComponentReferenceHandler.processReferenceQueue(EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE);
                workDone |= StoreComponentReferenceHandler.processReferenceQueue(EXPIRED_THREAD_LOCAL_TAILERS_QUEUE);
                if (workDone |= StoreComponentReferenceHandler.processWireQueue()) continue;
                LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE::shutdown));
    }
}

