/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.DocumentContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SingleChronicleQueueStoreTest {
    private static final int INDEX_SPACING = 4;
    private static final int RECORD_COUNT = 40;
    private static final RollCycles ROLL_CYCLE = RollCycles.DAILY;
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    private static void assertExcerptsAreIndexed(SingleChronicleQueue queue, long[] indices, Function<Integer, Boolean> shouldBeIndexed, ScanResult expectedScanResult) {
        SingleChronicleQueueStore wireStore = (SingleChronicleQueueStore)queue.storeForCycle(queue.cycle(), 0L, true);
        SCQIndexing indexing = wireStore.indexing;
        for (int i = 0; i < 40; ++i) {
            int startLinearScanCount = indexing.linearScanCount;
            ScanResult scanResult = indexing.moveToIndex((ExcerptContext)((SingleChronicleQueueExcerpts.StoreTailer)queue.createTailer()), indices[i]);
            Assert.assertThat((Object)scanResult, (Matcher)CoreMatchers.is((Object)expectedScanResult));
            if (shouldBeIndexed.apply(i).booleanValue()) {
                Assert.assertThat((Object)indexing.linearScanCount, (Matcher)CoreMatchers.is((Object)startLinearScanCount));
                continue;
            }
            Assert.assertThat((Object)indexing.linearScanCount, (Matcher)CoreMatchers.is((Object)(startLinearScanCount + 1)));
        }
    }

    private static long[] writeMessagesStoreIndices(ExcerptAppender appender, ExcerptTailer tailer) {
        Throwable throwable;
        DocumentContext ctx;
        int i;
        long[] indices = new long[40];
        for (i = 0; i < 40; ++i) {
            ctx = appender.writingDocument();
            throwable = null;
            try {
                ctx.wire().getValueOut().int32(i);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        for (i = 0; i < 40; ++i) {
            ctx = tailer.readingDocument();
            throwable = null;
            try {
                Assert.assertThat((String)("Expected record at index " + i), (Object)ctx.isPresent(), (Matcher)CoreMatchers.is((Object)true));
                indices[i] = tailer.index();
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        return indices;
    }

    @Test
    public void shouldPerformIndexingOnAppend() throws Exception {
        this.runTest((ThrowingConsumer<SingleChronicleQueue, Exception>)((ThrowingConsumer)queue -> {
            ExcerptAppender appender = queue.acquireAppender();
            long[] indices = SingleChronicleQueueStoreTest.writeMessagesStoreIndices(appender, queue.createTailer());
            SingleChronicleQueueStoreTest.assertExcerptsAreIndexed(queue, indices, i -> i % 4 == 0, ScanResult.FOUND);
        }));
    }

    private void runTest(ThrowingConsumer<SingleChronicleQueue, Exception> testMethod) throws Exception {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmpDir.newFolder()).testBlockSize().timeProvider(this.clock::get).rollCycle((RollCycle)ROLL_CYCLE).indexSpacing(4).build();){
            testMethod.accept((Object)queue);
        }
    }
}

