/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.threads.TimingPauser;

public abstract class AbstractTSQueueLock
implements Closeable {
    protected static final long UNLOCKED = Long.MIN_VALUE;
    private static final String QUEUE_LOCK_FILE = "queue-lock.cq4t";
    protected final LongValue lock;
    protected final TimingPauser pauser;
    protected final String path;
    protected final TableStore tableStore;

    public AbstractTSQueueLock(String lockKey, File queueDirectoryPath, Supplier<TimingPauser> pauser) {
        File storeFilePath;
        if ("".equals(queueDirectoryPath.getPath())) {
            storeFilePath = new File(QUEUE_LOCK_FILE);
        } else {
            storeFilePath = new File(queueDirectoryPath, QUEUE_LOCK_FILE);
            queueDirectoryPath.mkdirs();
        }
        this.tableStore = SingleTableBuilder.binary(storeFilePath).build();
        this.lock = this.tableStore.doWithExclusiveLock(ts -> ts.acquireValueFor(lockKey));
        this.pauser = pauser.get();
        this.path = storeFilePath.getPath();
    }

    @Override
    public void close() {
        Closeable.closeQuietly((Object)this.lock);
        this.tableStore.close();
    }

    protected void closeCheck() {
        if (this.tableStore.isClosed()) {
            throw new IllegalStateException("Underlying TableStore is already closed - was the Queue closed?");
        }
    }

    protected void forceUnlock() {
        Jvm.warn().on(this.getClass(), "Forced unlock", new Exception());
        this.lock.setValue(Long.MIN_VALUE);
    }
}

