/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.nio.file.Path;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Assert;

public class TestEmptyFile {
    Path tmpDir = DirectoryUtils.tempDir(TestEmptyFile.class.getSimpleName()).toPath();

    @After
    public void cleanup() {
        DirectoryUtils.deleteDir(this.tmpDir.toFile());
    }

    public void shouldHandleEmptyFile() {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.tmpDir).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            try (DocumentContext dc = ChronicleQueue.singleBuilder((Path)this.tmpDir).testBlockSize().build().acquireAppender().writingDocument();){
                dc.wire().write((CharSequence)"hello").text("world");
            }
            dc = tailer.readingDocument();
            var5_7 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"world", (Object)dc.wire().read("hello").text());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var5_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }
}

