/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;
import java.util.BitSet;
import net.openhft.chronicle.core.Jvm;

class BitSetUtil {
    private static Field wordsField;
    private static Field wordsInUse;
    private static Field sizeIsSticky;

    BitSetUtil() {
    }

    static long getWord(BitSet bs, int index) {
        try {
            long[] longs = (long[])wordsField.get(bs);
            return longs[index];
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow(e);
        }
    }

    static <E> BitSet set(BitSet using, long[] words) {
        try {
            wordsField.set(using, words);
            wordsInUse.set(using, words.length);
            sizeIsSticky.set(using, false);
            return using;
        }
        catch (IllegalAccessException e) {
            throw Jvm.rethrow(e);
        }
    }

    static {
        try {
            wordsField = BitSet.class.getDeclaredField("words");
            wordsField.setAccessible(true);
            wordsInUse = BitSet.class.getDeclaredField("wordsInUse");
            wordsInUse.setAccessible(true);
            sizeIsSticky = BitSet.class.getDeclaredField("sizeIsSticky");
            sizeIsSticky.setAccessible(true);
        }
        catch (Exception e) {
            Jvm.rethrow(e);
        }
    }
}

