/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesMarshaller;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BytesUtil {

    static final Map<AbstractBytes, Throwable> bytesCreated = Collections.synchronizedMap(new IdentityHashMap());

    public static Bytes readFile(@NotNull String name) throws IOException {
        File file = new File(name);
        URL url = null;
        if (!file.exists()) {
            url = IOTools.urlFor(name);
            file = new File(url.getFile());
        }
        return Bytes.wrapForRead(IOTools.readAsBytes(url == null ? new FileInputStream(file) : IOTools.open(url)));
    }

    public static boolean bytesEqual(@NotNull @net.openhft.chronicle.core.annotation.NotNull RandomDataInput a, long offset, @NotNull @net.openhft.chronicle.core.annotation.NotNull RandomDataInput second, long secondOffset, long len) throws BufferUnderflowException {
        long i = 0L;
        while (len - i >= 8L) {
            if (a.readLong(offset + i) != second.readLong(secondOffset + i)) {
                return false;
            }
            i += 8L;
        }
        if (len - i >= 4L) {
            if (a.readInt(offset + i) != second.readInt(secondOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (len - i >= 2L) {
            if (a.readShort(offset + i) != second.readShort(secondOffset + i)) {
                return false;
            }
            i += 2L;
        }
        return i >= len || a.readByte(offset + i) == second.readByte(secondOffset + i);
    }

    public static boolean bytesEqual(@Nullable CharSequence cs, @NotNull RandomDataInput bs, long offset, int length) {
        if (cs == null || cs.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cs.charAt(i) == bs.readUnsignedByte(offset + (long)i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return StringUtils.isEqual((CharSequence)o1, (CharSequence)o2);
        }
        return o1 != null && o1.equals(o2);
    }

    public static int asInt(@NotNull @net.openhft.chronicle.core.annotation.NotNull String str) {
        ByteBuffer bb = ByteBuffer.wrap(str.getBytes(StandardCharsets.ISO_8859_1)).order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    public static int stopBitLength(long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        return BytesInternal.stopBitLength0(n);
    }

    @NotNull
    public static char[] toCharArray(@NotNull Bytes bytes) {
        char[] chars = new char[Maths.toUInt31(bytes.readRemaining())];
        int i = 0;
        while ((long)i < bytes.readRemaining()) {
            chars[i] = (char)bytes.readUnsignedByte((long)i + bytes.readPosition());
            ++i;
        }
        return chars;
    }

    @NotNull
    public static char[] toCharArray(@NotNull Bytes bytes, long position, int length) {
        char[] chars = new char[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            chars[j++] = (char)bytes.readUnsignedByte(position + (long)i);
        }
        return chars;
    }

    public static long readStopBit(@NotNull StreamingDataInput in) throws IORuntimeException {
        return BytesInternal.readStopBit(in);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, long n) {
        BytesInternal.writeStopBit(out, n);
    }

    public static void parseUtf8(@NotNull @net.openhft.chronicle.core.annotation.NotNull StreamingDataInput in, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        BytesInternal.parseUtf8(in, appendable, utflen);
    }

    public static void appendUtf8(@NotNull @net.openhft.chronicle.core.annotation.NotNull StreamingDataOutput out, @NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence cs) {
        BytesInternal.appendUtf8(out, cs, 0, cs.length());
    }

    public static void appendBytesFromStart(@NotNull Bytes bytes, long startPosition, @NotNull StringBuilder sb) {
        try {
            BytesInternal.parse8bit(startPosition, bytes, sb, (int)(bytes.readPosition() - startPosition));
            sb.append('\u2016');
            sb.append(bytes);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void readMarshallable(@NotNull ReadBytesMarshallable marshallable, BytesIn bytes) {
        ((BytesMarshaller)BytesMarshaller.BYTES_MARSHALLER_CL.get(marshallable.getClass())).readMarshallable(marshallable, bytes);
    }

    public static void writeMarshallable(@NotNull WriteBytesMarshallable marshallable, BytesOut bytes) {
        ((BytesMarshaller)BytesMarshaller.BYTES_MARSHALLER_CL.get(marshallable.getClass())).writeMarshallable(marshallable, bytes);
    }

    @Deprecated
    public static long utf8Length(@NotNull CharSequence toWrite) {
        return AppendableUtil.findUtf8Length(toWrite);
    }

    public static boolean register(AbstractBytes bytes) {
        bytesCreated.put(bytes, new StackTrace("Created here"));
        return true;
    }

    public static void checkRegisteredBytes() {
        int count = 0;
        for (Map.Entry<AbstractBytes, Throwable> entry : bytesCreated.entrySet()) {
            AbstractBytes key = entry.getKey();
            if (key.refCount() == 0L) continue;
            System.err.println("Bytes " + key.getClass() + " refCount=" + key.refCount());
            entry.getValue().printStackTrace();
            ++count;
        }
        bytesCreated.clear();
        if (count != 0) {
            throw new IllegalStateException("Bytes not released properly " + count);
        }
    }

    public static boolean unregister(Bytes bytes) {
        bytesCreated.remove(bytes);
        return true;
    }

    public static boolean byteToBoolean(byte b) {
        return b != 0 && b != 78 && b != 110;
    }
}

