/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.Wires;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SingleChronicleQueueBuilderTest {
    private static final String TEST_QUEUE_FILE = "src/test/resources/tr2/20170320.cq4";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetermineQueueDirectoryFromQueueFile() {
        Path path = Paths.get(OS.USER_DIR, TEST_QUEUE_FILE);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)path).testBlockSize().build();){
            Assert.assertThat((Object)queue.createTailer().readingDocument().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            IOTools.deleteDirWithFiles((File)path.toFile(), (int)20);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfQueuePathIsFileWithIncorrectExtension() throws Exception {
        File tempFile = File.createTempFile(SingleChronicleQueueBuilderTest.class.getSimpleName(), ".txt");
        tempFile.deleteOnExit();
        SingleChronicleQueueBuilder.binary((File)tempFile);
    }

    @Test
    public void setAllNullFields() {
        SingleChronicleQueueBuilder b1 = SingleChronicleQueueBuilder.builder();
        SingleChronicleQueueBuilder b2 = SingleChronicleQueueBuilder.builder();
        b1.blockSize(1234567);
        b2.bufferCapacity(98765L);
        b2.setAllNullFields(b1);
        Assert.assertEquals((long)1234567L, (long)b2.blockSize());
        Assert.assertEquals((long)98765L, (long)b2.bufferCapacity());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAllNullFieldsShouldFailWithDifferentHierarchy() {
        SingleChronicleQueueBuilder b1 = (SingleChronicleQueueBuilder)Wires.tupleFor(SingleChronicleQueueBuilder.class, (String)"ChronicleQueueBuilder");
        SingleChronicleQueueBuilder b2 = SingleChronicleQueueBuilder.builder();
        b2.bufferCapacity(98765L);
        b1.blockSize(1234567);
        b2.setAllNullFields(b1);
    }
}

