/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.QueueInspector;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class QueueInspectorTest {
    private static final String PROPERTY_KEY = "wire.encodeTidInHeader";
    private static String previousValue = null;

    @BeforeClass
    public static void enableFeature() {
        previousValue = System.getProperty(PROPERTY_KEY);
        System.setProperty(PROPERTY_KEY, Boolean.TRUE.toString());
    }

    @AfterClass
    public static void resetFeature() {
        if (previousValue != null) {
            System.setProperty(PROPERTY_KEY, previousValue);
        } else {
            System.clearProperty(PROPERTY_KEY);
        }
    }

    @Test
    public void shouldDetermineWritingProcessIdWhenDocumentIsNotComplete() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().build();){
            QueueInspector inspector = new QueueInspector((RollingChronicleQueue)queue);
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)37L, ValueOut::int64);
            try (DocumentContext ctx = appender.writingDocument();){
                ctx.wire().write((CharSequence)"foo").int32(17L);
                int n = inspector.getWritingThreadId();
            }
        }
    }

    @Test
    public void shouldIndicateNoProcessIdWhenDocumentIsComplete() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).testBlockSize().build();){
            QueueInspector inspector = new QueueInspector((RollingChronicleQueue)queue);
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)37L, ValueOut::int64);
            try (DocumentContext ctx = appender.writingDocument();){
                ctx.wire().write((CharSequence)"foo").int32(17L);
            }
            int writingThreadId = inspector.getWritingThreadId();
            Assert.assertThat((Object)writingThreadId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)OS.getProcessId())));
            Assert.assertThat((Object)QueueInspector.isValidThreadId((int)writingThreadId), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    protected File getTmpDir() {
        String methodName = "QueueInspectorTest";
        return DirectoryUtils.tempDir("QueueInspectorTest" != null ? "QueueInspectorTest".replaceAll("[\\[\\]\\s]+", "_") : "NULL-" + UUID.randomUUID());
    }
}

