/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.service;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.service.EventLoopServiceWrapper;
import net.openhft.chronicle.queue.service.ServiceWrapper;
import net.openhft.chronicle.threads.EventGroup;
import org.jetbrains.annotations.NotNull;

public class ServiceWrapperBuilder<O>
implements Supplier<ServiceWrapper> {
    private final List<String> inputPaths = new ArrayList<String>();
    private final List<Function<O, Object>> serviceFunctions = new ArrayList<Function<O, Object>>();
    private String outputPath;
    private Class<O> outClass;
    private EventLoop eventLoop;
    private HandlerPriority priority = HandlerPriority.MEDIUM;
    private boolean createdEventLoop = false;
    private int inputSourceId;
    private int outputSourceId;

    ServiceWrapperBuilder() {
    }

    @NotNull
    public static <O> ServiceWrapperBuilder<O> serviceBuilder(String inputPath, String outputPath, Class<O> outClass, Function<O, Object> serviceFunction) {
        ServiceWrapperBuilder<O> swb = new ServiceWrapperBuilder<O>();
        swb.addInputPath(inputPath);
        swb.outputPath = outputPath;
        swb.outClass = outClass;
        swb.addServiceFunction(serviceFunction);
        return swb;
    }

    @NotNull
    public List<String> inputPath() {
        return this.inputPaths;
    }

    @NotNull
    public ServiceWrapperBuilder<O> addInputPath(String inputPath) {
        this.inputPaths.add(inputPath);
        return this;
    }

    public Class<O> outClass() {
        return this.outClass;
    }

    @NotNull
    public ServiceWrapperBuilder<O> outClass(Class<O> outClass) {
        this.outClass = outClass;
        return this;
    }

    public String outputPath() {
        return this.outputPath;
    }

    @NotNull
    public ServiceWrapperBuilder<O> outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @NotNull
    public List<Function<O, Object>> getServiceFunctions() {
        return this.serviceFunctions;
    }

    @NotNull
    public ServiceWrapperBuilder<O> addServiceFunction(Function<O, Object> serviceFunctions) {
        this.serviceFunctions.add(serviceFunctions);
        return this;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    public boolean createdEventLoop() {
        return this.createdEventLoop;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public HandlerPriority priority() {
        return this.priority;
    }

    @NotNull
    public ServiceWrapperBuilder<O> priority(HandlerPriority priority) {
        this.priority = priority;
        return this;
    }

    public int inputSourceId() {
        return this.inputSourceId;
    }

    @NotNull
    public ServiceWrapperBuilder<O> inputSourceId(int inputSourceId) {
        this.inputSourceId = inputSourceId;
        return this;
    }

    public int outputSourceId() {
        return this.outputSourceId;
    }

    @NotNull
    public ServiceWrapperBuilder<O> outputSourceId(int outputSourceId) {
        this.outputSourceId = outputSourceId;
        return this;
    }

    @Override
    @NotNull
    public ServiceWrapper get() {
        if (this.eventLoop == null) {
            this.eventLoop = new EventGroup(false);
            this.createdEventLoop = true;
        }
        return new EventLoopServiceWrapper(this);
    }

    @NotNull
    public ChronicleQueue inputQueue() {
        return SingleChronicleQueueBuilder.binary(this.inputPaths.get(0)).testBlockSize().sourceId(this.inputSourceId()).build();
    }

    @NotNull
    public ChronicleQueue outputQueue() {
        return SingleChronicleQueueBuilder.binary(this.outputPath).testBlockSize().sourceId(this.outputSourceId()).build();
    }

    @NotNull
    public MethodReader outputReader(Object ... impls) {
        ChronicleQueue queue = this.outputQueue();
        MethodReader reader = queue.createTailer().methodReader(impls);
        reader.closeIn(true);
        return reader;
    }

    @NotNull
    public <T> T inputWriter(Class<T> tClass) {
        ChronicleQueue queue = this.inputQueue();
        return queue.acquireAppender().methodWriterBuilder(tClass).recordHistory(true).onClose(queue).get();
    }
}

