/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.bytes.AbstractBytesStore;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class HeapBytesStore<Underlying>
extends AbstractBytesStore<HeapBytesStore<Underlying>, Underlying> {
    @Nullable
    private static final Memory MEMORY = OS.memory();
    private final AtomicLong refCount = new AtomicLong(1L);
    @NotNull
    private Object realUnderlyingObject;
    private int dataOffset;
    private long capacity;
    @NotNull
    private Underlying underlyingObject;

    public HeapBytesStore() {
    }

    private HeapBytesStore(@NotNull ByteBuffer byteBuffer) {
        this.init(byteBuffer);
    }

    private HeapBytesStore(@NotNull byte[] byteArray) {
        this.init(byteArray);
    }

    @NotNull
    public static <T> HeapBytesStore<T> uninitialized() {
        return new HeapBytesStore();
    }

    @NotNull
    static HeapBytesStore<byte[]> wrap(@NotNull byte[] byteArray) {
        return new HeapBytesStore<byte[]>(byteArray);
    }

    @NotNull
    static HeapBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new HeapBytesStore<ByteBuffer>(bb);
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    public void init(@NotNull ByteBuffer byteBuffer) {
        this.underlyingObject = byteBuffer;
        this.realUnderlyingObject = byteBuffer.array();
        this.dataOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset();
        this.capacity = byteBuffer.capacity();
    }

    public void init(@NotNull byte[] byteArray) {
        this.underlyingObject = (Underlying)byteArray;
        this.realUnderlyingObject = byteArray;
        this.dataOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        this.capacity = byteArray.length;
    }

    public void uninit() {
        this.underlyingObject = null;
        this.realUnderlyingObject = null;
        this.dataOffset = 0;
        this.capacity = 0L;
    }

    @Override
    public void move(long from, long to, long length) {
        if (from < 0L || to < 0L) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.realUnderlyingObject, Maths.toUInt31(from), this.realUnderlyingObject, Maths.toUInt31(to), Maths.toUInt31(length));
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return BytesInternal.toString(this);
        }
        catch (IllegalStateException e) {
            return e.toString();
        }
    }

    @Override
    @NotNull
    public BytesStore<HeapBytesStore<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void reserve() {
        this.refCount.incrementAndGet();
    }

    @Override
    public void release() {
        this.refCount.decrementAndGet();
    }

    @Override
    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return MEMORY.compareAndSwapInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return MEMORY.compareAndSwapLong(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
    }

    @Override
    public byte readByte(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 1);
        return MEMORY.readByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public short readShort(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 2);
        return MEMORY.readShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public int readInt(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 4);
        return MEMORY.readInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public long readLong(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 8);
        return MEMORY.readLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public float readFloat(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 4);
        return MEMORY.readFloat(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public double readDouble(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 8);
        return MEMORY.readDouble(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public byte readVolatileByte(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 1);
        return MEMORY.readVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public short readVolatileShort(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 2);
        return MEMORY.readVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public int readVolatileInt(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 4);
        return MEMORY.readVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    public long readVolatileLong(long offset) throws BufferUnderflowException {
        this.checkOffset(offset, 8);
        return MEMORY.readVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeByte(long offset, byte b) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1);
        MEMORY.writeByte(this.realUnderlyingObject, (long)this.dataOffset + offset, b);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeShort(long offset, short i16) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2);
        MEMORY.writeShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeInt(long offset, int i32) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4);
        MEMORY.writeInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeOrderedInt(long offset, int i32) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4);
        MEMORY.writeOrderedInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeLong(long offset, long i64) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8);
        MEMORY.writeLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeOrderedLong(long offset, long i) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8);
        MEMORY.writeOrderedLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeFloat(long offset, float f) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4);
        MEMORY.writeFloat(this.realUnderlyingObject, (long)this.dataOffset + offset, f);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeDouble(long offset, double d) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8);
        MEMORY.writeDouble(this.realUnderlyingObject, (long)this.dataOffset + offset, d);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException {
        this.writeCheckOffset(offset, 1);
        MEMORY.writeVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset, i8);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException {
        this.writeCheckOffset(offset, 2);
        MEMORY.writeVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException {
        this.writeCheckOffset(offset, 4);
        MEMORY.writeVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException {
        this.writeCheckOffset(offset, 8);
        MEMORY.writeVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
        return this;
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        MEMORY.copyMemory(bytes, offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        return this;
    }

    @Override
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) throws BufferOverflowException {
        this.writeCheckOffset(offsetInRDO, length);
        assert (this.realUnderlyingObject == null || this.dataOffset >= (Jvm.is64bit() ? 12 : 8));
        if (bytes.isDirect()) {
            MEMORY.copyMemory(((DirectBuffer)((Object)bytes)).address(), this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        } else {
            MEMORY.copyMemory(bytes.array(), offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<Underlying> write(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            long x = bytes.readLong(readOffset + i);
            this.writeLong(writeOffset + i, x);
        }
        while (i < length) {
            byte x = bytes.readByte(readOffset + i);
            this.writeByte(writeOffset + i, x);
            ++i;
        }
        return this;
    }

    @Override
    public long addressForRead(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWrite(long offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    private void checkOffset(long offset, int size) throws BufferUnderflowException {
        this.checkBounds(offset, size, DecoratedBufferUnderflowException::new);
    }

    private void writeCheckOffset(long offset, int size) throws BufferOverflowException {
        this.checkBounds(offset, size, DecoratedBufferOverflowException::new);
    }

    private void checkBounds(long offset, int size, Function<String, RuntimeException> exceptionFunction) {
        if (offset < this.start() || offset + (long)size > this.capacity) {
            throw exceptionFunction.apply(String.format("Offset: %d, start: %d, size: %d, capacity: %d", offset, this.start(), size, this.capacity));
        }
    }
}

