/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleCQFormatTest {
    private ThreadDump threadDump;

    private static void expected(@NotNull ExcerptTailer tailer, String expected) {
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertTrue((String)"No document found", (boolean)dc.isPresent());
            Bytes bytes2 = Bytes.elasticHeapByteBuffer((int)128);
            dc.wire().copyTo((WireOut)new TextWire(bytes2));
            Assert.assertEquals((Object)expected, (Object)bytes2.toString());
        }
    }

    @Test
    public void testEmptyDirectory() {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.firstCycle());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)queue.lastCycle());
        queue.close();
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    @Test
    public void testInvalidFile() throws FileNotFoundException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)65536L);){
            bytes.write8bit("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>");
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize().build();){
                Assert.assertEquals((long)1L, (long)queue.firstCycle());
                Assert.assertEquals((long)1L, (long)queue.lastCycle());
                try {
                    ExcerptTailer tailer = queue.createTailer();
                    tailer.toEnd();
                    Assert.fail();
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"java.io.StreamCorruptedException: Unexpected magic number 783f3c37", (Object)e.toString());
                }
            }
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testNoHeader() throws IOException {
        File dir = new File(OS.TARGET + "/deleteme-" + System.nanoTime());
        dir.mkdir();
        File file = new File(dir, "19700101.cq4");
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] bytes = new byte[1024];
            for (int i = 0; i < 128; ++i) {
                fos.write(bytes);
            }
        }
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize().build();
        this.testQueue(queue);
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TimeoutException.class)
    public void testDeadHeader() throws IOException {
        File dir = DirectoryUtils.tempDir("testDeadHeader");
        dir.mkdirs();
        File file = new File(dir, "19700101.cq4");
        file.createNewFile();
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)65536L);
        bytes.writeInt(-1073741824);
        bytes.release();
        SingleChronicleQueue queue = null;
        try {
            queue = SingleChronicleQueueBuilder.binary((File)dir).timeoutMS(1000L).testBlockSize().blockSize(65536).build();
            this.testQueue(queue);
        }
        catch (Throwable throwable) {
            Closeable.closeQuietly(queue);
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
            throw throwable;
        }
        Closeable.closeQuietly((Object)queue);
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    private void testQueue(@NotNull SingleChronicleQueue queue) {
        ExcerptTailer tailer = queue.createTailer();
        try (DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
    }

    @Test
    public void testCompleteHeader() throws FileNotFoundException {
        File dir = DirectoryUtils.tempDir("testCompleteHeader");
        dir.mkdirs();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)131072L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> {
                w.write(() -> "wireType").object((Object)WireType.BINARY);
                w.write(() -> "writePosition").int64forBinding(0L);
                w.write(() -> "roll").typedMarshallable((WriteMarshallable)new SCQRoll((RollCycle)RollCycles.TEST4_DAILY, 0L));
                w.write(() -> "indexing").typedMarshallable((WriteMarshallable)new SCQIndexing(WireType.BINARY, 32, 4));
                w.write(() -> "lastAcknowledgedIndexReplicated").int64forBinding(0L);
            });
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: 0\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize().build();
        this.testQueue(queue);
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCompleteHeader2() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101-02.cq4"), (long)131072L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typedMarshallable((WriteMarshallable)new SingleChronicleQueueStore((RollCycle)RollCycles.HOURLY, WireType.BINARY, bytes, 4096, 4));
        }
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    0,\n    0\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: !short 4096,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.HOURLY).build();
        this.testQueue(queue);
        Assert.assertEquals((long)2L, (long)queue.firstCycle());
        queue.close();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncompleteHeader() throws FileNotFoundException {
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)65536L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> w.write(() -> "wireType").object((Object)WireType.BINARY));
        }
        bytes.release();
        try {
            var5_7 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST4_DAILY).blockSize(65536).build();){
                this.testQueue(queue);
                Assert.fail();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.IORuntimeException: net.openhft.chronicle.core.io.IORuntimeException: field writePosition required", (Object)e.toString());
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.threadDump.ignore("disk-space-checker");
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }
}

