/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.TreeMap;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.micros.Order;
import net.openhft.chronicle.queue.micros.Side;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleCQFormat2Test
extends ChronicleQueueTestBase {
    private int appendMode;
    private ThreadDump threadDump;

    private static void assertHexEquals(long a, long b) {
        if (a != b) {
            Assert.assertEquals((String)(Long.toHexString(a) + " != " + Long.toHexString(b)), (long)a, (long)b);
        }
    }

    @Test
    public void testMyData() {
        File dir = this.getTmpDir();
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{MyData.class});
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                MyData name = new MyData("name", 12345L, 1.2, 111);
                System.out.println((Object)name);
                name.writeMarshallable((WireOut)dc.wire());
                MyData name2 = new MyData("name2", 12346L, 1.3, 112);
                System.out.println((Object)name2);
                name2.writeMarshallable((WireOut)dc.wire());
            }
            String dump = queue.dump();
            Assert.assertTrue((String)dump, (boolean)dump.contains("--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  464,\n  0, 0, 0, 0, 0, 0, 0\n]"));
        }
    }

    @Test
    public void testWritingThreeMessages() throws FileNotFoundException {
        int m = 0;
        while (m <= 2) {
            this.appendMode = m++;
            File dir = this.getTmpDir();
            dir.mkdir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(1).build();){
                long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
                this.appendMessage(queue, start, "Hello World");
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    464,\n    1992864825344\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  464,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 130584 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager);
                this.appendMessage(queue, start + 1L, "Another Hello World");
                String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    484,\n    2078764171265\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  464,\n  484,\n  0, 0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 484, header: 1\n--- !!data #binary\nmsg: Another Hello World\n...\n# 130556 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager2);
                this.appendMessage(queue, start + 2L, "Bye for now");
                String expectedEager3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    512,\n    2199023255554\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 3\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 3\n  464,\n  484,\n  512,\n  0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 484, header: 1\n--- !!data #binary\nmsg: Another Hello World\n# position: 512, header: 2\n--- !!data #binary\nmsg: Bye for now\n...\n# 130536 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager3);
            }
        }
    }

    private File getFirstQueueFile(File file) {
        return file.listFiles((d, n) -> n.endsWith(".cq4"))[0];
    }

    public void checkFileContents(@NotNull File file, String expected) throws FileNotFoundException {
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)65536L);
        bytes.readLimit(bytes.realCapacity());
        Assert.assertEquals((Object)expected, (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes));
        bytes.release();
    }

    @Test
    public void testWritingTwentyMessagesTinyIndex() throws FileNotFoundException {
        for (int spacing : new int[]{1, 2, 4}) {
            File dir = this.getTmpDir();
            dir.mkdir();
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).indexCount(8).indexSpacing(spacing).build();){
                long start = RollCycles.DAILY.toIndex(queue.cycle(), 0L);
                ExcerptTailer tailer = queue.createTailer();
                Assert.assertFalse((boolean)tailer.moveToIndex(start));
                this.appendMessage(queue, start, "Hello World");
                String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    464,\n    1992864825344\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  464,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n...\n# 130584 bytes remaining\n";
                this.checkFileContents(this.getFirstQueueFile(dir), expectedEager.replace("indexSpacing: 1", "indexSpacing: " + spacing).replace("lastIndex: 1", "lastIndex: " + spacing));
                Assert.assertTrue((boolean)tailer.moveToIndex(start));
                for (int i = 1; i < 19; ++i) {
                    Assert.assertFalse((boolean)tailer.moveToIndex(start + (long)i));
                    this.appendMessage(queue, start + (long)i, "Another Hello World " + (i + 1));
                    Assert.assertTrue((boolean)tailer.moveToIndex(start + (long)i));
                }
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 19L));
                this.appendMessage(queue, start + 19L, "Bye for now");
                Assert.assertTrue((boolean)tailer.moveToIndex(start + 19L));
                Assert.assertFalse((boolean)tailer.moveToIndex(start + 20L));
                String expected1 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1230,\n    5282809774099\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  368,\n  726,\n  1072,\n  0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  464,\n  484,\n  514,\n  544,\n  576,\n  606,\n  636,\n  666\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 484, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 514, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 544, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 576, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 606, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 636, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 666, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 696, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 726, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  696,\n  824,\n  855,\n  886,\n  917,\n  948,\n  979,\n  1010\n]\n# position: 824, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 855, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 886, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 917, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 948, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 979, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 1010, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 1041, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 1072, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 4\n  1041,\n  1168,\n  1199,\n  1230,\n  0, 0, 0, 0\n]\n# position: 1168, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1199, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1230, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129818 bytes remaining\n";
                String expected2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1134,\n    4870492913683\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 2,\n    index2Index: 264,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 2\n  368,\n  974,\n  0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  464,\n  514,\n  576,\n  636,\n  696,\n  757,\n  819,\n  881\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 484, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 514, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 544, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 576, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 606, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 636, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 666, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 696, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 726, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 757, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 788, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 819, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 850, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 881, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 912, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 943, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 974, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  943,\n  1103,\n  0, 0, 0, 0, 0, 0\n]\n# position: 1072, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1103, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1134, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 129914 bytes remaining\n";
                String expected3 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1036,\n    4449586118675\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 4,\n    index2Index: 264,\n    lastIndex: 20\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 5\n  464,\n  576,\n  696,\n  819,\n  943,\n  0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nmsg: Hello World\n# position: 484, header: 1\n--- !!data #binary\nmsg: Another Hello World 2\n# position: 514, header: 2\n--- !!data #binary\nmsg: Another Hello World 3\n# position: 544, header: 3\n--- !!data #binary\nmsg: Another Hello World 4\n# position: 576, header: 4\n--- !!data #binary\nmsg: Another Hello World 5\n# position: 606, header: 5\n--- !!data #binary\nmsg: Another Hello World 6\n# position: 636, header: 6\n--- !!data #binary\nmsg: Another Hello World 7\n# position: 666, header: 7\n--- !!data #binary\nmsg: Another Hello World 8\n# position: 696, header: 8\n--- !!data #binary\nmsg: Another Hello World 9\n# position: 726, header: 9\n--- !!data #binary\nmsg: Another Hello World 10\n# position: 757, header: 10\n--- !!data #binary\nmsg: Another Hello World 11\n# position: 788, header: 11\n--- !!data #binary\nmsg: Another Hello World 12\n# position: 819, header: 12\n--- !!data #binary\nmsg: Another Hello World 13\n# position: 850, header: 13\n--- !!data #binary\nmsg: Another Hello World 14\n# position: 881, header: 14\n--- !!data #binary\nmsg: Another Hello World 15\n# position: 912, header: 15\n--- !!data #binary\nmsg: Another Hello World 16\n# position: 943, header: 16\n--- !!data #binary\nmsg: Another Hello World 17\n# position: 974, header: 17\n--- !!data #binary\nmsg: Another Hello World 18\n# position: 1005, header: 18\n--- !!data #binary\nmsg: Another Hello World 19\n# position: 1036, header: 19\n--- !!data #binary\nmsg: Bye for now\n...\n# 130012 bytes remaining\n";
                String expected = spacing == 1 ? expected1 : (spacing == 2 ? expected2 : expected3);
                this.checkFileContents(this.getFirstQueueFile(dir), expected);
            }
        }
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.threadDump.ignore("disk-space-checker");
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void resetAppendMode() {
        this.appendMode = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void appendMessage(@NotNull SingleChronicleQueue queue, long expectedIndex, String msg) {
        appender = queue.acquireAppender();
        switch (this.appendMode) {
            case 1: {
                appender.writeDocument((WriteMarshallable)LambdaMetafactory.metafactory(null, null, null, (Lnet/openhft/chronicle/wire/WireOut;)V, lambda$appendMessage$2(java.lang.String net.openhft.chronicle.wire.WireOut ), (Lnet/openhft/chronicle/wire/WireOut;)V)((String)msg));
                break;
            }
            case 2: {
                bytes = Bytes.elasticByteBuffer();
                new BinaryWire(bytes).write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$3(), ()Ljava/lang/CharSequence;)()).text(msg);
                appender.writeBytes(bytes);
                bytes.release();
                break;
            }
            default: {
                dc = appender.writingDocument();
                var8_8 = null;
                wire = dc.wire();
                wire.write((WireKey)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/CharSequence;, lambda$appendMessage$4(), ()Ljava/lang/CharSequence;)()).text(msg);
                if (dc == null) break;
                if (var8_8 == null) ** GOTO lbl28
                try {
                    dc.close();
                }
                catch (Throwable var9_10) {
                    var8_8.addSuppressed(var9_10);
                }
                break;
lbl28:
                // 1 sources

                dc.close();
                break;
                catch (Throwable var9_11) {
                    try {
                        var8_8 = var9_11;
                        throw var9_11;
                    }
                    catch (Throwable var10_12) {
                        if (dc != null) {
                            if (var8_8 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable var11_13) {
                                    var8_8.addSuppressed(var11_13);
                                }
                            } else {
                                dc.close();
                            }
                        }
                        throw var10_12;
                    }
                }
            }
        }
        index = appender.lastIndexAppended();
        SingleCQFormat2Test.assertHexEquals(expectedIndex, index);
    }

    @Test
    public void writeMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("abc", "def");
        map.put("hello", "world");
        map.put("number", 1L);
        map.put("double", 1.28);
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).blockSize(65536).rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeMap(map);
            map.put("abc", "aye-bee-see");
            appender.writeMap(map);
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    524,\n    2250562863105\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  464,\n  524,\n  0, 0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nabc: def\ndouble: 1.28\nhello: world\nnumber: 1\n# position: 524, header: 1\n--- !!data #binary\nabc: aye-bee-see\ndouble: 1.28\nhello: world\nnumber: 1\n...\n# 130476 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
            ExcerptTailer tailer = queue.createTailer();
            Map map2 = tailer.readMap();
            Map map3 = tailer.readMap();
            Assert.assertEquals((Object)"{abc=def, double=1.28, hello=world, number=1}", (Object)map2.toString());
            Assert.assertEquals((Object)"{abc=aye-bee-see, double=1.28, hello=world, number=1}", (Object)map3.toString());
            Assert.assertNull((Object)tailer.readMap());
        }
    }

    @Test
    public void writeMarshallable() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Order.class});
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((WriteMarshallable)new Order("Symbol", Side.Buy, 1.2345, 1000000.0));
            appender.writeDocument(w -> w.write((CharSequence)"newOrder").object((Object)new Order("Symbol2", Side.Sell, 2.999, 1.0E7)));
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    519,\n    2229088026625\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 2\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 2\n  464,\n  519,\n  0, 0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data #binary\nsymbol: Symbol\nside: Buy\nlimitPrice: 1.2345\nquantity: 1E6\n# position: 519, header: 1\n--- !!data #binary\nnewOrder: !Order {\n  symbol: Symbol2,\n  side: Sell,\n  limitPrice: 2.999,\n  quantity: 10E6\n}\n...\n# 130470 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
        }
    }

    @Test
    public void testWritingIndex() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single((File)dir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).blockSize(65536).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"msg-1");
            String expectedEager = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    464,\n    1992864825344\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 1\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  464,\n  0, 0, 0, 0, 0, 0, 0\n]\n# position: 464, header: 0\n--- !!data\nmsg-1\n...\n# 130595 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager, (Object)queue.dump());
            for (int i = 1; i <= 16; ++i) {
                appender.writeText((CharSequence)("msg-" + i));
            }
            String expectedEager2 = "--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    709,\n    3045131812880\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 8,\n    indexSpacing: 1,\n    index2Index: 264,\n    lastIndex: 17\n  },\n  lastAcknowledgedIndexReplicated: -1,\n  lastIndexReplicated: -1\n}\n# position: 264, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 8, used: 3\n  368,\n  545,\n  719,\n  0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  464,\n  473,\n  482,\n  491,\n  500,\n  509,\n  518,\n  527\n]\n# position: 464, header: 0\n--- !!data\nmsg-1\n# position: 473, header: 1\n--- !!data\nmsg-1\n# position: 482, header: 2\n--- !!data\nmsg-2\n# position: 491, header: 3\n--- !!data\nmsg-3\n# position: 500, header: 4\n--- !!data\nmsg-4\n# position: 509, header: 5\n--- !!data\nmsg-5\n# position: 518, header: 6\n--- !!data\nmsg-6\n# position: 527, header: 7\n--- !!data\nmsg-7\n# position: 536, header: 8\n--- !!data\nmsg-8\n# position: 545, header: 8\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 8\n  536,\n  640,\n  649,\n  659,\n  669,\n  679,\n  689,\n  699\n]\n# position: 640, header: 9\n--- !!data\nmsg-9\n# position: 649, header: 10\n--- !!data\nmsg-10\n# position: 659, header: 11\n--- !!data\nmsg-11\n# position: 669, header: 12\n--- !!data\nmsg-12\n# position: 679, header: 13\n--- !!data\nmsg-13\n# position: 689, header: 14\n--- !!data\nmsg-14\n# position: 699, header: 15\n--- !!data\nmsg-15\n# position: 709, header: 16\n--- !!data\nmsg-16\n# position: 719, header: 16\n--- !!meta-data #binary\nindex: [\n  # length: 8, used: 1\n  709,\n  0, 0, 0, 0, 0, 0, 0\n]\n...\n# 130252 bytes remaining\n";
            Assert.assertEquals((Object)expectedEager2, (Object)queue.dump());
        }
    }

    @After
    public void checkMappedFiles() {
        MappedFile.checkMappedFiles();
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$4() {
        return "msg";
    }

    private static /* synthetic */ CharSequence lambda$appendMessage$3() {
        return "msg";
    }

    private static /* synthetic */ void lambda$appendMessage$2(String msg, WireOut w) {
        w.write(() -> "msg").text(msg);
    }

    static {
        SingleChronicleQueueBuilder.init();
    }

    private static class MyData
    extends AbstractMarshallable {
        final String name;
        final long num;
        final double d;
        final int counter;

        MyData(String name, long num, double d, int counter) {
            this.name = name;
            this.num = num;
            this.d = d;
            this.counter = counter;
        }
    }
}

