/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;

public class ThroughputPerfMain {
    static final int time = Integer.getInteger("time", 20);
    static final int size = Integer.getInteger("size", 48);
    static final String path = System.getProperty("path", OS.TMP);
    static NativeBytesStore nbs;

    public static void main(String[] args) {
        DocumentContext dc;
        String base = path + "/delete-" + System.nanoTime() + ".me";
        long start = System.nanoTime();
        long count = 0L;
        nbs = NativeBytesStore.nativeStoreWithFixedCapacity((long)size);
        long blockSize = 0x100000000L;
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((String)base).rollCycle((RollCycle)RollCycles.LARGE_HOURLY_SPARSE).blockSize(blockSize).build();){
            ExcerptAppender appender = q.acquireAppender();
            long lastIndex = -1L;
            do {
                int batch = Math.max(1, 131072 / size);
                int defaultIndexSpacing = q.rollCycle().defaultIndexSpacing();
                for (int i = 0; i < batch; ++i) {
                    Wire wire = appender.wire();
                    int writeCount = (int)((long)defaultIndexSpacing - (lastIndex & (long)(defaultIndexSpacing - 1)) - 1L);
                    if (wire != null && writeCount > 0) {
                        MappedBytes bytes = (MappedBytes)wire.bytes();
                        long address = bytes.addressForWrite(bytes.writePosition());
                        long bstart = bytes.start();
                        long bcap = bytes.realCapacity();
                        long canWrite = bcap - (bytes.writePosition() - bstart);
                        long lengthCount = ThroughputPerfMain.writeMessages(address, canWrite, writeCount);
                        bytes.writeSkip((long)((int)lengthCount));
                        lastIndex += lengthCount >> 32;
                        count += lengthCount >> 32;
                        continue;
                    }
                    dc = appender.writingDocument();
                    Throwable throwable = null;
                    try {
                        dc.wire().bytes().write((BytesStore)nbs);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc != null) {
                            if (throwable != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                dc.close();
                            }
                        }
                    }
                    lastIndex = appender.lastIndexAppended();
                    ++count;
                }
            } while ((double)start + (double)time * 1.0E9 > (double)System.nanoTime());
        }
        nbs.release();
        long mid = System.nanoTime();
        long time1 = mid - start;
        NativeBytes bytes = Bytes.allocateElasticDirect((long)64L);
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((String)base).rollCycle((RollCycle)RollCycles.LARGE_HOURLY_SPARSE).blockSize(blockSize).build();){
            ExcerptTailer tailer = q.createTailer();
            for (long i = 0L; i < count; ++i) {
                dc = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    bytes.clear();
                    bytes.write((BytesStore)dc.wire().bytes());
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dc != null) {
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
        }
        bytes.release();
        long end = System.nanoTime();
        long time2 = end - mid;
        System.out.printf("Writing %,d messages took %.3f seconds, at a rate of %,d per second%n", count, (double)time1 / 1.0E9, (long)(1.0E9 * (double)count / (double)time1));
        System.out.printf("Reading %,d messages took %.3f seconds, at a rate of %,d per second%n", count, (double)time2 / 1.0E9, (long)(1.0E9 * (double)count / (double)time2));
        System.gc();
        IOTools.deleteDirWithFiles((String)base, (int)2);
    }

    private static long writeMessages(long address, long canWrite, int writeCount) {
        long count;
        long length = 0L;
        long fromAddress = nbs.addressForRead(0L);
        for (count = 0L; (long)writeCount > count && length + 4L + (long)size <= canWrite; ++count) {
            UnsafeMemory.UNSAFE.copyMemory(fromAddress, address + 4L, size);
            UnsafeMemory.UNSAFE.putOrderedInt(null, address, size);
            address += (long)(4 + size);
            length += (long)(4 + size);
        }
        return count << 32 | length;
    }
}

