/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.DumpQueueMain;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DumpQueueMainTest {
    @Test
    public void shouldBeAbleToDumpReadOnlyQueueFile() throws Exception {
        if (OS.isWindows()) {
            return;
        }
        File dataDir = DirectoryUtils.tempDir(DumpQueueMainTest.class.getSimpleName());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dataDir).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            excerptAppender.writeText((CharSequence)"first");
            excerptAppender.writeText((CharSequence)"last");
            Path queueFile = Files.list(dataDir.toPath()).filter(p -> p.toString().endsWith(".cq4")).findFirst().orElseThrow(() -> new AssertionError((Object)("Could not find queue file in directory " + dataDir)));
            Assert.assertThat((Object)queueFile.toFile().setWritable(false), (Matcher)CoreMatchers.is((Object)true));
            CountingOutputStream countingOutputStream = new CountingOutputStream();
            DumpQueueMain.dump((File)queueFile.toFile(), (PrintStream)new PrintStream(countingOutputStream), (long)Long.MAX_VALUE);
            Assert.assertThat((Object)countingOutputStream.bytes, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0L)));
        }
    }

    @Test
    public void shouldDumpDirectoryListing() throws Exception {
        File dataDir = DirectoryUtils.tempDir(DumpQueueMainTest.class.getSimpleName());
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dataDir).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            excerptAppender.writeText((CharSequence)"first");
            excerptAppender.writeText((CharSequence)"last");
            ByteArrayOutputStream capture = new ByteArrayOutputStream();
            DumpQueueMain.dump((File)dataDir, (PrintStream)new PrintStream(capture), (long)Long.MAX_VALUE);
            String capturedOutput = new String(capture.toByteArray());
            Assert.assertThat((Object)capturedOutput, (Matcher)CoreMatchers.containsString((String)"listing.highestCycle"));
            Assert.assertThat((Object)capturedOutput, (Matcher)CoreMatchers.containsString((String)"listing.lowestCycle"));
        }
    }

    private static final class CountingOutputStream
    extends OutputStream {
        private long bytes;

        private CountingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.bytes;
        }
    }
}

