/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.RollCycleEncodeSequence;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
implements WireStore {
    @NotNull
    final SCQIndexing indexing;
    @NotNull
    private final LongValue writePosition;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final ReferenceCounter refCount;
    @Nullable
    private LongValue lastAcknowledgedIndexReplicated;
    private final LongValue lastIndexReplicated;
    @NotNull
    private transient Sequence sequence;
    private volatile Thread lastAccessedThread;

    @UsedViaReflection
    private SingleChronicleQueueStore(@NotNull WireIn wire) {
        assert (wire.startUse());
        try {
            this.writePosition = this.loadWritePosition(wire);
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.refCount = ReferenceCounter.onReleased(this::onCleanup);
            this.indexing = (SCQIndexing)Objects.requireNonNull(wire.read(MetaDataField.indexing).typedMarshallable());
            assert (this.indexing != null);
            this.indexing.writePosition = this.writePosition;
            this.lastAcknowledgedIndexReplicated = wire.bytes().readRemaining() > 0L ? wire.read(MetaDataField.lastAcknowledgedIndexReplicated).int64ForBinding(null) : null;
            this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, this.rollIndexCount(), this.rollIndexSpacing());
            this.lastIndexReplicated = wire.bytes().readRemaining() > 0L ? wire.read(MetaDataField.lastIndexReplicated).int64ForBinding(null) : null;
        }
        finally {
            assert (wire.endUse());
        }
    }

    public SingleChronicleQueueStore(@NotNull RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, int indexCount, int indexSpacing) {
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        indexCount = Maths.nextPower2(indexCount, 8);
        indexSpacing = Maths.nextPower2(indexSpacing, 1);
        this.indexing = new SCQIndexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newTwoLongReference().get();
        this.indexing.sequence = this.sequence = new RollCycleEncodeSequence(this.writePosition, rollCycle.defaultIndexCount(), rollCycle.defaultIndexSpacing());
        this.lastAcknowledgedIndexReplicated = wireType.newLongReference().get();
        this.lastIndexReplicated = wireType.newLongReference().get();
    }

    @NotNull
    public static String dump(@NotNull String directoryFilePath) {
        return ((SingleChronicleQueue)SingleChronicleQueueBuilder.binary(directoryFilePath).build()).dump();
    }

    private static WireOut intForBinding(ValueOut wireOut, LongValue value) {
        return value instanceof TwoLongValue ? wireOut.int128forBinding(0L, 0L, (TwoLongValue)value) : wireOut.int64forBinding(0L, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongValue loadWritePosition(@NotNull WireIn wire) {
        int code;
        ValueIn read = wire.read(MetaDataField.writePosition);
        long start = wire.bytes().readPosition();
        try {
            wire.consumePadding();
            code = wire.bytes().uncheckedReadUnsignedByte();
        }
        finally {
            wire.bytes().readPosition(start);
        }
        if (code == 141) {
            TwoLongValue result = wire.newTwoLongReference();
            read.int128(result);
            return result;
        }
        LongValue result = wire.newLongReference();
        read.int64(result);
        return result;
    }

    @Override
    @NotNull
    public File file() {
        return this.mappedFile.file();
    }

    @Override
    public long lastAcknowledgedIndexReplicated() {
        return this.lastAcknowledgedIndexReplicated == null ? -1L : this.lastAcknowledgedIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastAcknowledgedIndexReplicated(long newValue) {
        if (this.lastAcknowledgedIndexReplicated != null) {
            this.lastAcknowledgedIndexReplicated.setMaxValue(newValue);
        }
    }

    @Override
    public long lastIndexReplicated() {
        return this.lastIndexReplicated == null ? -1L : this.lastIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastIndexReplicated(long indexReplicated) {
        if (this.lastIndexReplicated != null) {
            this.lastIndexReplicated.setMaxValue(indexReplicated);
        }
    }

    @Override
    @NotNull
    public String dump() {
        MappedBytes bytes = MappedBytes.mappedBytes(this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs(bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    @NotNull
    public WireStore writePosition(long position) {
        assert (this.singleThreadedAccess());
        assert (this.writePosition.getVolatileValue() + this.mappedFile.chunkSize() > position);
        assert (Wires.isReadyData(this.mappedBytes.readVolatileInt(position)));
        this.writePosition.setMaxValue(position);
        return this;
    }

    @Override
    @Nullable
    public ScanResult moveToIndexForRead(@NotNull ExcerptContext ec, long index) {
        try {
            return this.indexing.moveToIndex(ec, index);
        }
        catch (UnrecoverableTimeoutException e) {
            return ScanResult.NOT_REACHED;
        }
    }

    @Override
    public long moveToEndForRead(@NotNull Wire w) {
        return this.indexing.moveToEnd(w);
    }

    @Override
    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    @Override
    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    @Override
    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes(this.mappedFile);
    }

    @Override
    public long sequenceForPosition(@NotNull ExcerptContext ec, long position, boolean inclusive) throws UnrecoverableTimeoutException, StreamCorruptedException {
        return this.indexing.sequenceForPosition(ec, position, inclusive);
    }

    @Override
    public long lastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        return this.indexing.lastSequenceNumber(ec);
    }

    @NotNull
    public String toString() {
        return "SingleChronicleQueueStore{indexing=" + this.indexing + ", writePosition/seq=" + this.writePosition.toString() + ", mappedFile=" + this.mappedFile + ", refCount=" + this.refCount + ", lastAcknowledgedIndexReplicated=" + this.lastAcknowledgedIndexReplicated + ", lastIndexReplicated=" + this.lastIndexReplicated + '}';
    }

    private void onCleanup() {
        Closeable.closeQuietly((Object)this.writePosition);
        Closeable.closeQuietly((Object)this.indexing);
        Closeable.closeQuietly((Object)this.lastAcknowledgedIndexReplicated);
        Closeable.closeQuietly((Object)this.lastIndexReplicated);
        this.mappedBytes.release();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        if (this.lastAcknowledgedIndexReplicated == null) {
            this.lastAcknowledgedIndexReplicated = wire.newLongReference();
        }
        ValueOut wireOut = wire.write(MetaDataField.writePosition);
        SingleChronicleQueueStore.intForBinding(wireOut, this.writePosition).write(MetaDataField.indexing).typedMarshallable(this.indexing).write(MetaDataField.lastAcknowledgedIndexReplicated).int64forBinding(-1L, this.lastAcknowledgedIndexReplicated).write(MetaDataField.lastIndexReplicated).int64forBinding(-1L, this.lastIndexReplicated);
        wire.padToCacheAlign();
    }

    @Override
    public void initIndex(@NotNull Wire wire) {
        try {
            this.indexing.initIndex(wire);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean indexable(long index) {
        return this.indexing.indexable(index);
    }

    @Override
    public void setPositionForSequenceNumber(@NotNull ExcerptContext ec, long sequenceNumber, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
        this.sequence.setSequence(sequenceNumber, position);
        long nextSequence = this.indexing.nextEntryToBeIndexed();
        if (nextSequence > sequenceNumber) {
            return;
        }
        this.indexing.setPositionForSequenceNumber(ec, sequenceNumber, position);
    }

    @Override
    public ScanResult linearScanTo(long index, long knownIndex, ExcerptContext ec, long knownAddress) {
        return this.indexing.linearScanTo(index, knownIndex, ec, knownAddress);
    }

    @Override
    public void writeEOF(@NotNull Wire wire, long timeoutMS) {
        if (wire.bytes().tryReserve()) {
            wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, this.writePosition());
            wire.bytes().release();
        } else {
            Jvm.debug().on(this.getClass(), "Tried to writeEOF to as it was being closed");
        }
    }

    int rollIndexCount() {
        return this.indexing.indexCount();
    }

    int rollIndexSpacing() {
        return this.indexing.indexSpacing();
    }

    private synchronized boolean singleThreadedAccess() {
        if (this.lastAccessedThread == null) {
            this.lastAccessedThread = Thread.currentThread();
        }
        return this.lastAccessedThread == Thread.currentThread();
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQIndexing.class);
    }
}

