/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class TimedStoreRecovery
extends AbstractMarshallable
implements StoreRecovery,
Demarshallable {
    public static final StoreRecoveryFactory FACTORY = TimedStoreRecovery::new;
    private final LongValue timeStamp;

    @UsedViaReflection
    public TimedStoreRecovery(@NotNull WireIn in) {
        this.timeStamp = in.read("timeStamp").int64ForBinding(in.newLongReference());
    }

    public TimedStoreRecovery(@NotNull WireType wireType) {
        this.timeStamp = wireType.newLongReference().get();
    }

    @NotNull
    private static ExceptionHandler warn() {
        return Slf4jExceptionHandler.WARN;
    }

    @Override
    public void writeMarshallable(@NotNull WireOut out) {
        out.write("timeStamp").int64forBinding(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long recoverAndWriteHeader(@NotNull Wire wire, long timeoutMS, LongValue lastPosition, Sequence sequence) throws UnrecoverableTimeoutException {
        Bytes<?> bytes = wire.bytes();
        long offset = bytes.writePosition();
        int num = bytes.readVolatileInt(offset);
        long targetHeaderNumber = wire.headerNumber() + 1L;
        String msgStart = "Unable to write a header at header number: 0x" + Long.toHexString(targetHeaderNumber) + " position: " + offset;
        if (Wires.isNotComplete(num)) {
            int sizeToSkip = 32768;
            if (bytes instanceof MappedBytes) {
                MappedBytes mb = (MappedBytes)bytes;
                sizeToSkip = Maths.toUInt31(mb.mappedFile().overlapSize() / 2L);
            }
            sizeToSkip = sizeToSkip + 3 & 0xFFFFFFFC;
            sizeToSkip -= (int)(offset & 3L);
            long pos = bytes.writePosition();
            try {
                bytes.writeSkip(4L);
                String debugMessage = "!! Skipped due to recovery of locked header !! By thread " + Thread.currentThread().getName() + ", pid " + OS.getProcessId();
                wire.getValueOut().text(debugMessage);
                StringWriter stackVisitor = new StringWriter();
                new RuntimeException().printStackTrace(new PrintWriter(stackVisitor));
                String stackTrace = stackVisitor.toString();
                if (debugMessage.length() + stackTrace.length() + 16 < sizeToSkip) {
                    wire.getValueOut().text(stackTrace);
                }
                wire.addPadding(Math.toIntExact((long)sizeToSkip + (pos + 4L) - bytes.writePosition()));
            }
            finally {
                bytes.writePosition(pos);
            }
            int emptyMetaData = 0x40000000 | sizeToSkip;
            if (bytes.compareAndSwapInt(offset, num, emptyMetaData)) {
                TimedStoreRecovery.warn().on(this.getClass(), msgStart + " switching to a corrupt meta data message");
                bytes.writeSkip(sizeToSkip + 4);
            } else {
                int num2 = bytes.readVolatileInt(offset);
                TimedStoreRecovery.warn().on(this.getClass(), msgStart + " already set to " + Integer.toHexString(num2));
            }
        } else {
            TimedStoreRecovery.warn().on(this.getClass(), msgStart + " but message now exists.");
        }
        try {
            return wire.writeHeaderOfUnknownLength(timeoutMS, TimeUnit.MILLISECONDS, lastPosition, sequence);
        }
        catch (TimeoutException e) {
            TimedStoreRecovery.warn().on(this.getClass(), e);
            return this.recoverAndWriteHeader(wire, timeoutMS, lastPosition, sequence);
        }
        catch (EOFException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void close() {
        Closeable.closeQuietly((Object)this.timeStamp);
    }
}

