/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Objects;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class SCQMeta
implements Metadata {
    @NotNull
    private final SCQRoll roll;
    private final int deltaCheckpointInterval;
    private final int sourceId;

    @UsedViaReflection
    SCQMeta(@NotNull WireIn wire) {
        this.roll = (SCQRoll)Objects.requireNonNull(wire.read(MetaDataField.roll).typedMarshallable());
        this.deltaCheckpointInterval = wire.bytes().readRemaining() > 0L ? wire.read(MetaDataField.deltaCheckpointInterval).int32() : -1;
        this.sourceId = wire.bytes().readRemaining() > 0L ? wire.read(MetaDataField.sourceId).int32() : 0;
    }

    SCQMeta(@NotNull SCQRoll roll, int deltaCheckpointInterval, int sourceId) {
        this.roll = roll;
        this.deltaCheckpointInterval = deltaCheckpointInterval;
        this.sourceId = sourceId;
    }

    @NotNull
    public SCQRoll roll() {
        return this.roll;
    }

    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval;
    }

    public int sourceId() {
        return this.sourceId;
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(MetaDataField.roll).typedMarshallable(this.roll).write(MetaDataField.deltaCheckpointInterval).int32(this.deltaCheckpointInterval).write(MetaDataField.sourceId).int32(this.sourceId);
    }

    @Override
    public <T extends Metadata> void ensureSame(T metadata) {
        if (!(metadata instanceof SCQMeta)) {
            throw new IllegalStateException("Expected SCQMeta, got " + metadata.getClass());
        }
        SCQMeta other = (SCQMeta)metadata;
        SCQRoll roll = other.roll;
        if (roll.epoch() != this.roll.epoch()) {
            throw new IllegalStateException("Roll epoch mismatch, expected " + roll.epoch() + ", got " + this.roll.epoch());
        }
        if (roll.length() != this.roll.length()) {
            throw new IllegalStateException("Roll length mismatch, expected " + roll.length() + ", got " + this.roll.length());
        }
        assert (other.sourceId == 0 || this.sourceId == 0 || other.sourceId == this.sourceId) : "inconsistency with of source ids, existing sourceid=" + other.sourceId + ", requested sourceid=" + this.sourceId;
    }
}

