/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.Closeable;
import java.util.function.IntConsumer;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;

public final class Pretoucher
implements Closeable {
    private final long PRETOUCHER_PREROLL_TIME_MS = Long.getLong("SingleChronicleQueueExcerpts.pretoucherPrerollTimeMs", 2000L);
    private final boolean EARLY_ACQUIRE_NEXT_CYCLE = Boolean.getBoolean("SingleChronicleQueueExcerpts.earlyAcquireNextCycle");
    private final SingleChronicleQueue queue;
    private final NewChunkListener chunkListener;
    private final IntConsumer cycleChangedListener;
    private final PretoucherState pretoucherState;
    private final TimeProvider pretouchTimeProvider;
    private int currentCycle = Integer.MIN_VALUE;
    private WireStore currentCycleWireStore;
    private MappedBytes currentCycleMappedBytes;

    public Pretoucher(SingleChronicleQueue queue) {
        this(queue, null, c -> {});
    }

    Pretoucher(SingleChronicleQueue queue, NewChunkListener chunkListener, IntConsumer cycleChangedListener) {
        this.queue = queue;
        this.chunkListener = chunkListener;
        this.cycleChangedListener = cycleChangedListener;
        queue.addCloseListener(this, Pretoucher::releaseResources);
        this.pretoucherState = new PretoucherState(this::getStoreWritePosition);
        this.pretouchTimeProvider = () -> queue.time().currentTimeMillis() + (this.EARLY_ACQUIRE_NEXT_CYCLE ? this.PRETOUCHER_PREROLL_TIME_MS : 0L);
    }

    public void execute() throws InvalidEventHandlerException {
        this.assignCurrentCycle();
        try {
            this.pretoucherState.pretouch(this.currentCycleMappedBytes);
        }
        catch (IllegalStateException e) {
            if (this.queue.isClosed()) {
                throw new InvalidEventHandlerException(e);
            }
            Jvm.warn().on(this.getClass(), e);
        }
    }

    public void shutdown() {
        this.queue.close();
    }

    private void assignCurrentCycle() {
        int qCycle = this.queue.cycle(this.pretouchTimeProvider);
        if (qCycle != this.currentCycle) {
            this.releaseResources();
            this.currentCycleWireStore = this.queue.storeForCycle(qCycle, this.queue.epoch(), true);
            this.currentCycleMappedBytes = this.currentCycleWireStore.bytes();
            this.currentCycle = qCycle;
            if (this.chunkListener != null) {
                this.currentCycleMappedBytes.setNewChunkListener(this.chunkListener);
            }
            this.cycleChangedListener.accept(qCycle);
            if (this.EARLY_ACQUIRE_NEXT_CYCLE && Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "Pretoucher ROLLING early to next file=" + this.currentCycleWireStore.file());
            }
        }
    }

    private long getStoreWritePosition() {
        return this.currentCycleWireStore.writePosition();
    }

    private void releaseResources() {
        if (this.currentCycleWireStore != null) {
            this.queue.release(this.currentCycleWireStore);
            this.currentCycleWireStore = null;
        }
        if (this.currentCycleMappedBytes != null) {
            this.currentCycleMappedBytes.close();
            this.currentCycleMappedBytes = null;
        }
    }

    @Override
    public void close() {
        this.releaseResources();
    }
}

