/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ToEndTest {
    long lastCycle;
    private ThreadDump threadDump;
    private Map<ExceptionKey, Integer> exceptionKeyIntegerMap;

    @Before
    public void before() {
        this.threadDump = new ThreadDump();
        this.threadDump.ignore("queue-thread-local-cleaner-daemon");
        this.exceptionKeyIntegerMap = Jvm.recordExceptions();
    }

    @After
    public void after() {
        this.threadDump.assertNoNewThreads();
        if (Jvm.hasException(this.exceptionKeyIntegerMap)) {
            Jvm.dumpException(this.exceptionKeyIntegerMap);
            Assert.fail();
        }
        Jvm.resetExceptionHandlers();
    }

    @Test
    public void missingCyclesToEndTest() throws InterruptedException {
        String path = OS.TARGET + "/missingCyclesToEndTest-" + System.nanoTime();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider timeProvider = new SetTimeProvider();
        long now = 1470757797000L;
        long timeIncMs = 1001L;
        timeProvider.currentTimeMillis(now);
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)timeProvider).build();
        ExcerptAppender appender = queue.acquireAppender();
        appender.writeDocument(wire -> wire.write(() -> "msg").int32(1));
        timeProvider.currentTimeMillis(now += timeIncMs);
        appender.writeDocument(wire -> wire.write(() -> "msg").int32(2));
        appender.writeDocument(wire -> wire.write(() -> "msg").int32(3));
        ExcerptTailer tailer = queue.createTailer().toEnd();
        try (DocumentContext dc = tailer.readingDocument();){
            if (dc.isPresent()) {
                Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + String.valueOf(dc.wire().read(() -> "msg").int32())));
            }
        }
        appender.writeDocument(wire -> wire.write(() -> "msg").int32(4));
        dc = tailer.readingDocument();
        var11_11 = null;
        try {
            Assert.assertTrue((String)"Should be able to read entry in this cycle. Got NoDocumentContext.", (boolean)dc.isPresent());
            int i = dc.wire().read(() -> "msg").int32();
            junit.framework.Assert.assertEquals((String)("Should've read 4, instead we read: " + i), (int)4, (int)i);
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var11_11 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        tailer.toStart();
        for (int j = 1; j <= 4; ++j) {
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                int i = dc.wire().read(() -> "msg").int32();
                junit.framework.Assert.assertEquals((int)j, (int)i);
                continue;
            }
        }
        dc = tailer.readingDocument();
        var11_11 = null;
        try {
            if (dc.isPresent()) {
                Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + String.valueOf(dc.wire().read(() -> "msg").int32())));
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var11_11 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        appender.writeDocument(wire -> wire.write(() -> "msg").int32(5));
        timeProvider.currentTimeMillis(now += timeIncMs * 5L);
        dc = tailer.readingDocument();
        var11_11 = null;
        try {
            Assert.assertTrue((boolean)dc.isPresent());
            junit.framework.Assert.assertEquals((int)5, (int)dc.wire().read(() -> "msg").int32());
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var11_11 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
        dc = tailer.readingDocument();
        var11_11 = null;
        try {
            Assert.assertFalse((boolean)dc.isPresent());
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var11_11 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
    }

    @Test
    public void tailerToEndIncreasesRefCount() throws Exception {
        String path = OS.TARGET + "/toEndIncRefCount-" + System.nanoTime();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider time = new SetTimeProvider();
        long now = System.currentTimeMillis();
        time.currentTimeMillis(now);
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)time).build();
        SingleChronicleQueueExcerpts.StoreAppender appender = (SingleChronicleQueueExcerpts.StoreAppender)queue.acquireAppender();
        Field storeF1 = SingleChronicleQueueExcerpts.StoreAppender.class.getDeclaredField("store");
        storeF1.setAccessible(true);
        SingleChronicleQueueStore store1 = (SingleChronicleQueueStore)storeF1.get(appender);
        System.out.println(store1);
        appender.writeDocument(wire -> wire.write(() -> "msg").int32(1));
        SingleChronicleQueueExcerpts.StoreTailer tailer = (SingleChronicleQueueExcerpts.StoreTailer)queue.createTailer();
        System.out.println(tailer);
        tailer.toEnd();
        System.out.println(tailer);
        Field storeF2 = SingleChronicleQueueExcerpts.StoreTailer.class.getDeclaredField("store");
        storeF2.setAccessible(true);
        SingleChronicleQueueStore store2 = (SingleChronicleQueueStore)storeF2.get(tailer);
        junit.framework.Assert.assertEquals((long)1L, (long)store2.refCount());
    }

    @Test
    public void toEndTest() {
        File baseDir = DirectoryUtils.tempDir("toEndTest");
        ArrayList<Integer> results = new ArrayList<Integer>();
        Object singleChronicleQueue = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).indexCount(8).indexSpacing(1).build();){
            this.checkOneFile(baseDir);
            ExcerptAppender appender = queue.acquireAppender();
            this.checkOneFile(baseDir);
            int i = 0;
            while (i < 10) {
                int j = i++;
                appender.writeDocument(wire -> wire.write(() -> "msg").int32(j));
            }
            this.checkOneFile(baseDir);
            ExcerptTailer tailer = queue.createTailer();
            this.checkOneFile(baseDir);
            ExcerptTailer atEnd = tailer.toEnd();
            junit.framework.Assert.assertEquals((long)10L, (long)queue.rollCycle().toSequenceNumber(atEnd.index()));
            this.checkOneFile(baseDir);
            this.fillResults(atEnd, results);
            this.checkOneFile(baseDir);
            junit.framework.Assert.assertEquals((int)0, (int)results.size());
            tailer.toStart();
            this.checkOneFile(baseDir);
            this.fillResults(tailer, results);
            junit.framework.Assert.assertEquals((int)10, (int)results.size());
            this.checkOneFile(baseDir);
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((File)baseDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void toEndBeforeWriteTest() {
        File baseDir = DirectoryUtils.tempDir("toEndBeforeWriteTest");
        IOTools.shallowDeleteDirWithFiles((File)baseDir);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().build();){
            this.checkOneFile(baseDir);
            ExcerptAppender appender = queue.acquireAppender();
            this.checkOneFile(baseDir);
            ExcerptTailer tailer = queue.createTailer();
            this.checkOneFile(baseDir);
            ExcerptTailer tailer2 = queue.createTailer();
            this.checkOneFile(baseDir);
            tailer.toEnd();
            this.checkOneFile(baseDir);
            tailer2.toEnd();
            this.checkOneFile(baseDir);
        }
        System.gc();
        IOTools.shallowDeleteDirWithFiles((File)baseDir);
    }

    @Test
    public void toEndAfterWriteTest() {
        File file = DirectoryUtils.tempDir("toEndAfterWriteTest");
        IOTools.shallowDeleteDirWithFiles((File)file);
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(1470757797000L);
        try (SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = wqueue.acquireAppender();
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write().text("hi-" + i);
                    this.lastCycle = wqueue.rollCycle().toCycle(dc.index());
                }
                stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            }
        }
        var4_4 = null;
        try (SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptTailer tailer = rqueue.createTailer();
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            while (tailer.readText() != null) {
            }
            Assert.assertNull((Object)tailer.readText());
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            ExcerptTailer tailer1 = rqueue.createTailer();
            ExcerptTailer excerptTailer = tailer1.toEnd();
            Assert.assertNull((Object)excerptTailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        System.gc();
        IOTools.shallowDeleteDirWithFiles((File)file);
    }

    private void checkOneFile(@NotNull File baseDir) {
        Object[] files = baseDir.list((d, n) -> n.endsWith(".cq4"));
        if (files == null || files.length == 0) {
            return;
        }
        if (files.length == 1) {
            Assert.assertTrue((String)files[0], (boolean)files[0].startsWith("2"));
        } else {
            Assert.fail((String)("Too many files " + Arrays.toString(files)));
        }
    }

    @NotNull
    private List<Integer> fillResults(@NotNull ExcerptTailer tailer, @NotNull List<Integer> results) {
        for (int i = 0; i < 10; ++i) {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (!documentContext.isPresent()) break;
                results.add(documentContext.wire().read(() -> "msg").int32());
                continue;
            }
        }
        return results;
    }

    @After
    public void checkMappedFiles() {
        System.gc();
        Jvm.pause((long)50L);
        MappedFile.checkMappedFiles();
    }
}

