/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class PretoucherTest {
    private final File path = DirectoryUtils.tempDir(PretoucherTest.class.getSimpleName());
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());
    private final List<Integer> capturedCycles = new ArrayList<Integer>();
    private final CapturingChunkListener chunkListener = new CapturingChunkListener();

    @Test
    public void shouldHandleCycleRoll() throws Exception {
        try (SingleChronicleQueue queue = PretoucherTest.createQueue(this.path, this.clock::get);){
            Pretoucher pretoucher = new Pretoucher(queue, (NewChunkListener)this.chunkListener, this.capturedCycles::add);
            IntStream.range(0, 10).forEach(i -> {
                try (DocumentContext ctx = queue.acquireAppender().writingDocument();){
                    ctx.wire().write().int32(i);
                    pretoucher.execute();
                    ctx.wire().write().bytes(new byte[1024]);
                }
                pretoucher.execute();
                this.clock.addAndGet(TimeUnit.SECONDS.toMillis(5L));
            });
            Assert.assertThat((Object)this.capturedCycles.size(), (Matcher)CoreMatchers.is((Object)10));
            Assert.assertThat((Object)this.chunkListener.chunkMap.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @After
    public void deleteDir() throws Exception {
        DirectoryUtils.deleteDir(this.path);
    }

    private static SingleChronicleQueue createQueue(File path, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((File)path).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().wireType(WireType.BINARY).build();
    }

    private static final class CapturingChunkListener
    implements NewChunkListener {
        private final TreeMap<String, List<Integer>> chunkMap = new TreeMap();

        private CapturingChunkListener() {
        }

        public void onNewChunk(String filename, int chunk, long delayMicros) {
            this.chunkMap.computeIfAbsent(filename, f -> new ArrayList()).add(chunk);
        }
    }
}

