/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SingleChronicleQueueBuilderTest {
    private static final String TEST_QUEUE_FILE = "src/test/resources/tr2/20170320.cq4";

    @Test
    public void shouldDetermineQueueDirectoryFromQueueFile() throws Exception {
        Path path = Paths.get(OS.USER_DIR, TEST_QUEUE_FILE);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)path).testBlockSize().build();){
            Assert.assertThat((Object)queue.createTailer().readingDocument().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfQueuePathIsFileWithIncorrectExtension() throws Exception {
        File tempFile = File.createTempFile(SingleChronicleQueueBuilderTest.class.getSimpleName(), ".txt");
        tempFile.deleteOnExit();
        SingleChronicleQueueBuilder.binary((File)tempFile);
    }
}

